/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipsetrader.core.views.ISessionData;
import org.eclipsetrader.core.views.IViewItem;

public class ViewItemLabelProvider
extends CellLabelProvider {
    public static final String K_FADE_LEVELS = "fade_levels";
    private Color evenRowsColor = Display.getDefault().getSystemColor(25);
    private Color oddRowsColor = Display.getDefault().getSystemColor(19);
    private Color tickBackgroundColor = Display.getDefault().getSystemColor(31);
    private Color[] tickOddRowsFade = new Color[3];
    private Color[] tickEvenRowsFade = new Color[3];

    public ViewItemLabelProvider() {
        this.setTickBackground(Display.getDefault().getSystemColor(31).getRGB());
    }

    public void dispose() {
        int i = 0;
        while (i < this.tickEvenRowsFade.length) {
            this.tickEvenRowsFade[i].dispose();
            ++i;
        }
        i = 0;
        while (i < this.tickOddRowsFade.length) {
            this.tickOddRowsFade[i].dispose();
            ++i;
        }
        super.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return property != null;
    }

    public void update(ViewerCell cell) {
        IViewItem element = (IViewItem)cell.getElement();
        IAdaptable[] values = element.getValues();
        if (values != null && cell.getColumnIndex() >= 0 && cell.getColumnIndex() < values.length) {
            if (values[cell.getColumnIndex()] != null) {
                Color color;
                Image i;
                String s = (String)values[cell.getColumnIndex()].getAdapter(String.class);
                if (s != null && !cell.getText().equals(s)) {
                    cell.setText(s);
                }
                if ((i = (Image)values[cell.getColumnIndex()].getAdapter(Image.class)) != cell.getImage()) {
                    cell.setImage(i);
                }
                if ((color = (Color)values[cell.getColumnIndex()].getAdapter(Color.class)) != null) {
                    cell.setForeground(color);
                }
            } else {
                if (!cell.getText().equals("")) {
                    cell.setText("");
                }
                if (cell.getImage() != null) {
                    cell.setImage(null);
                }
                cell.setForeground(null);
            }
        } else {
            if (!cell.getText().equals("")) {
                cell.setText("");
            }
            if (cell.getImage() != null) {
                cell.setImage(null);
            }
            cell.setForeground(null);
        }
        this.updateBackground(cell);
    }

    protected void updateBackground(ViewerCell cell) {
        if (cell.getControl() instanceof Table && cell.getItem() instanceof TableItem) {
            int rowIndex = ((Table)cell.getControl()).indexOf((TableItem)cell.getItem());
            cell.setBackground((rowIndex & 1) != 0 ? this.oddRowsColor : this.evenRowsColor);
            IViewItem element = (IViewItem)cell.getElement();
            ISessionData data = (ISessionData)element.getAdapter(ISessionData.class);
            if (data != null) {
                int[] timers = (int[])data.getData((Object)K_FADE_LEVELS);
                int columnIndex = cell.getColumnIndex();
                if (timers != null && columnIndex < timers.length && timers[columnIndex] > 0) {
                    switch (timers[columnIndex]) {
                        case 4: {
                            cell.setBackground((rowIndex & 1) != 0 ? this.tickOddRowsFade[0] : this.tickEvenRowsFade[0]);
                            break;
                        }
                        case 3: {
                            cell.setBackground((rowIndex & 1) != 0 ? this.tickOddRowsFade[1] : this.tickEvenRowsFade[1]);
                            break;
                        }
                        case 2: {
                            cell.setBackground((rowIndex & 1) != 0 ? this.tickOddRowsFade[2] : this.tickEvenRowsFade[2]);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            cell.setBackground(this.tickBackgroundColor);
                            break;
                        }
                    }
                }
            }
        } else {
            cell.setBackground(this.evenRowsColor);
            IViewItem element = (IViewItem)cell.getElement();
            ISessionData data = (ISessionData)element.getAdapter(ISessionData.class);
            if (data != null) {
                int[] timers = (int[])data.getData((Object)K_FADE_LEVELS);
                int columnIndex = cell.getColumnIndex();
                if (timers != null && columnIndex < timers.length && timers[columnIndex] > 0) {
                    switch (timers[columnIndex]) {
                        case 4: {
                            cell.setBackground(this.tickEvenRowsFade[0]);
                            break;
                        }
                        case 3: {
                            cell.setBackground(this.tickEvenRowsFade[1]);
                            break;
                        }
                        case 2: {
                            cell.setBackground(this.tickEvenRowsFade[2]);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            cell.setBackground(this.tickBackgroundColor);
                        }
                    }
                }
            }
        }
    }

    public void setTickBackground(RGB color) {
        RGB rgb;
        int steps = 100 / (this.tickEvenRowsFade.length + 1);
        int i = 0;
        int ratio = 100 - steps;
        while (i < this.tickEvenRowsFade.length) {
            rgb = this.blend(this.tickBackgroundColor.getRGB(), this.evenRowsColor.getRGB(), ratio);
            this.tickEvenRowsFade[i] = new Color((Device)Display.getDefault(), rgb);
            ++i;
            ratio -= steps;
        }
        steps = 100 / (this.tickOddRowsFade.length + 1);
        i = 0;
        ratio = 100 - steps;
        while (i < this.tickOddRowsFade.length) {
            rgb = this.blend(this.tickBackgroundColor.getRGB(), this.oddRowsColor.getRGB(), ratio);
            this.tickOddRowsFade[i] = new Color((Device)Display.getDefault(), rgb);
            ++i;
            ratio -= steps;
        }
    }

    private RGB blend(RGB c1, RGB c2, int ratio) {
        int r = this.blend(c1.red, c2.red, ratio);
        int g = this.blend(c1.green, c2.green, ratio);
        int b = this.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private int blend(int v1, int v2, int ratio) {
        return (ratio * v1 + (100 - ratio) * v2) / 100;
    }
}

