/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipsetrader.core.feed.IBook;
import org.eclipsetrader.core.feed.ILastClose;
import org.eclipsetrader.core.feed.IPrice;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.feed.ITodayOHL;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.views.Holding;
import org.eclipsetrader.core.views.IWatchListElement;
import org.eclipsetrader.ui.internal.ats.ViewItem;
import org.eclipsetrader.ui.internal.views.WatchListViewModel;

public class WatchListViewItem
implements ViewItem {
    public static final String PROP_QUANTITY = "position";
    public static final String PROP_PRICE = "purchasePrice";
    private final WatchListViewModel parent;
    private final IWatchListElement element;
    private final ISecurity security;
    private IPrice price;
    private ITrade trade;
    private IQuote quote;
    private ITodayOHL todayOHL;
    private ILastClose lastClose;
    private IBook book;
    private Long position;
    private Double purchasePrice;
    private final Map<String, Object> values = new HashMap<String, Object>();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public WatchListViewItem(WatchListViewModel parent, IWatchListElement element) {
        this.parent = parent;
        this.element = element;
        this.security = element.getSecurity();
        this.position = element.getPosition();
        this.purchasePrice = element.getPurchasePrice();
    }

    public IWatchListElement getElement() {
        return this.element;
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public Object getValue(String name) {
        return this.values.get(name);
    }

    @Override
    public void putValue(String name, Object value) {
        Object oldValue = this.values.put(name, value);
        this.changeSupport.firePropertyChange(name, oldValue, value);
    }

    @Override
    public ViewItem getParent() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public ObservableList getItems() {
        return null;
    }

    public ISecurity getSecurity() {
        return this.security;
    }

    public void setPriceData(Object obj) {
        if (obj instanceof IPrice) {
            this.price = (IPrice)obj;
        }
        if (obj instanceof ITrade) {
            this.trade = (ITrade)obj;
        }
        if (obj instanceof IQuote) {
            this.quote = (IQuote)obj;
        }
        if (obj instanceof ILastClose) {
            this.lastClose = (ILastClose)obj;
        }
        if (obj instanceof ITodayOHL) {
            this.todayOHL = (ITodayOHL)obj;
        }
        if (obj instanceof IBook) {
            this.book = (IBook)obj;
        }
    }

    public IPrice getPrice() {
        return this.price;
    }

    public void setPrice(IPrice price) {
        this.price = price;
    }

    public ITrade getTrade() {
        return this.trade;
    }

    public void setTrade(ITrade trade) {
        this.trade = trade;
    }

    public IQuote getQuote() {
        return this.quote;
    }

    public void setQuote(IQuote quote) {
        this.quote = quote;
    }

    public ITodayOHL getTodayOHL() {
        return this.todayOHL;
    }

    public void setTodayOHL(ITodayOHL todayOHL) {
        this.todayOHL = todayOHL;
    }

    public ILastClose getLastClose() {
        return this.lastClose;
    }

    public void setLastClose(ILastClose lastClose) {
        this.lastClose = lastClose;
    }

    public IBook getBook() {
        return this.book;
    }

    public void setBook(IBook book) {
        this.book = book;
    }

    public Long getPosition() {
        return this.position;
    }

    public Double getPurchasePrice() {
        return this.purchasePrice;
    }

    public Object getAdapter(Class adapter) {
        Object obj;
        if (this.security != null && (obj = this.security.getAdapter(adapter)) != null) {
            return obj;
        }
        if (adapter.isAssignableFrom(Holding.class)) {
            return new Holding(){

                public Long getPosition() {
                    return WatchListViewItem.this.position;
                }

                public void setPosition(Long position) {
                    PropertyChangeSupport propertyChangeSupport = WatchListViewItem.this.changeSupport;
                    Long l = WatchListViewItem.this.position;
                    Long l2 = position;
                    WatchListViewItem.this.position = l2;
                    propertyChangeSupport.firePropertyChange(WatchListViewItem.PROP_QUANTITY, l, l2);
                }

                public Double getPurchasePrice() {
                    return WatchListViewItem.this.purchasePrice;
                }

                public void setPurchasePrice(Double purchasePrice) {
                    PropertyChangeSupport propertyChangeSupport = WatchListViewItem.this.changeSupport;
                    Double d = WatchListViewItem.this.purchasePrice;
                    Double d2 = purchasePrice;
                    WatchListViewItem.this.purchasePrice = d2;
                    propertyChangeSupport.firePropertyChange(WatchListViewItem.PROP_PRICE, d, d2);
                }
            };
        }
        if (adapter.isAssignableFrom(IPrice.class)) {
            return this.price;
        }
        if (adapter.isAssignableFrom(ITrade.class)) {
            return this.trade;
        }
        if (adapter.isAssignableFrom(IQuote.class)) {
            return this.quote;
        }
        if (adapter.isAssignableFrom(ITodayOHL.class)) {
            return this.todayOHL;
        }
        if (adapter.isAssignableFrom(ILastClose.class)) {
            return this.lastClose;
        }
        if (adapter.isAssignableFrom(IBook.class)) {
            return this.book;
        }
        if (adapter.isAssignableFrom(this.element.getClass())) {
            return this.element;
        }
        Object result = this.element.getAdapter(adapter);
        if (result != null) {
            return result;
        }
        result = this.parent.getAdapter(adapter);
        if (result != null) {
            return result;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }
}

