/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.feed.IPricingEnvironment;
import org.eclipsetrader.core.feed.IPricingListener;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.core.views.IWatchListColumn;
import org.eclipsetrader.core.views.IWatchListElement;
import org.eclipsetrader.core.views.WatchList;
import org.eclipsetrader.core.views.WatchListColumn;
import org.eclipsetrader.core.views.WatchListElement;
import org.eclipsetrader.ui.internal.providers.GainValue;
import org.eclipsetrader.ui.internal.views.WatchListViewColumn;
import org.eclipsetrader.ui.internal.views.WatchListViewItem;
import org.eclipsetrader.ui.internal.views.WatchListViewModelTotalsItem;

public class WatchListViewModel
implements IAdaptable {
    public static final String PROP_NAME = "name";
    public static final String PROP_DIRTY = "dirty";
    private String name;
    private final WatchList watchList;
    private final IPricingEnvironment pricingEnvironment;
    private final List<WatchListViewColumn> columns = new ArrayList<WatchListViewColumn>();
    private final WritableList observableColumns = new WritableList(this.columns, WatchListViewColumn.class);
    private final List<WatchListViewItem> items = new ArrayList<WatchListViewItem>();
    private final WritableList observableItems = new WritableList(this.items, WatchListViewItem.class);
    private WatchListViewModelTotalsItem totalsItem;
    private NumberFormat formatter = NumberFormat.getInstance();
    private NumberFormat percentageFormatter = NumberFormat.getInstance();
    private Color positiveColor = Display.getDefault().getSystemColor(5);
    private Color negativeColor = Display.getDefault().getSystemColor(3);
    private boolean dirty;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private final IPricingListener pricingListener = new IPricingListener(){

        public void pricingUpdate(PricingEvent event) {
            WatchListViewModel.this.doPricingUpdate(event);
        }
    };
    private final PropertyChangeListener holdingChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            WatchListViewItem viewItem = (WatchListViewItem)evt.getSource();
            WatchListViewModel.this.updateValues(viewItem);
            PropertyChangeSupport propertyChangeSupport = WatchListViewModel.this.changeSupport;
            boolean bl = WatchListViewModel.this.dirty;
            WatchListViewModel.this.dirty = true;
            propertyChangeSupport.firePropertyChange(WatchListViewModel.PROP_DIRTY, bl, true);
        }
    };

    public WatchListViewModel(WatchList watchList, IPricingEnvironment pricingEnvironment) {
        this.name = watchList.getName();
        this.watchList = watchList;
        this.pricingEnvironment = pricingEnvironment;
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(0);
        this.formatter.setMaximumFractionDigits(2);
        this.percentageFormatter.setGroupingUsed(true);
        this.percentageFormatter.setMinimumIntegerDigits(1);
        this.percentageFormatter.setMinimumFractionDigits(2);
        this.percentageFormatter.setMaximumFractionDigits(2);
        IWatchListColumn[] columns = watchList.getColumns();
        int i = 0;
        while (i < columns.length) {
            this.observableColumns.add((Object)new WatchListViewColumn(columns[i]));
            ++i;
        }
        IWatchListElement[] elements = watchList.getItems();
        int i2 = 0;
        while (i2 < elements.length) {
            WatchListViewItem viewItem = new WatchListViewItem(this, elements[i2]);
            viewItem.setTrade(pricingEnvironment.getTrade(elements[i2].getSecurity()));
            viewItem.setQuote(pricingEnvironment.getQuote(elements[i2].getSecurity()));
            viewItem.setLastClose(pricingEnvironment.getLastClose(elements[i2].getSecurity()));
            viewItem.setTodayOHL(pricingEnvironment.getTodayOHL(elements[i2].getSecurity()));
            viewItem.setBook(pricingEnvironment.getBook(elements[i2].getSecurity()));
            viewItem.addPropertyChangeListener("position", this.holdingChangeListener);
            viewItem.addPropertyChangeListener("purchasePrice", this.holdingChangeListener);
            this.observableItems.add((Object)viewItem);
            ++i2;
        }
        this.totalsItem = new WatchListViewModelTotalsItem();
        this.update();
        this.observableItems.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                event.diff.accept(new ListDiffVisitor(){

                    public void handleAdd(int index, Object element) {
                        WatchListViewItem viewItem = (WatchListViewItem)element;
                        WatchListViewModel.this.init(viewItem);
                        viewItem.addPropertyChangeListener("position", WatchListViewModel.this.holdingChangeListener);
                        viewItem.addPropertyChangeListener("purchasePrice", WatchListViewModel.this.holdingChangeListener);
                        PropertyChangeSupport propertyChangeSupport = WatchListViewModel.this.changeSupport;
                        boolean bl = WatchListViewModel.this.dirty;
                        WatchListViewModel.this.dirty = true;
                        propertyChangeSupport.firePropertyChange(WatchListViewModel.PROP_DIRTY, bl, true);
                    }

                    public void handleRemove(int index, Object element) {
                        WatchListViewItem viewItem = (WatchListViewItem)element;
                        viewItem.removePropertyChangeListener("position", WatchListViewModel.this.holdingChangeListener);
                        viewItem.removePropertyChangeListener("purchasePrice", WatchListViewModel.this.holdingChangeListener);
                        PropertyChangeSupport propertyChangeSupport = WatchListViewModel.this.changeSupport;
                        boolean bl = WatchListViewModel.this.dirty;
                        WatchListViewModel.this.dirty = true;
                        propertyChangeSupport.firePropertyChange(WatchListViewModel.PROP_DIRTY, bl, true);
                    }
                });
            }
        });
        this.observableColumns.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                event.diff.accept(new ListDiffVisitor(){

                    public void handleAdd(int index, Object element) {
                        WatchListViewColumn column = (WatchListViewColumn)element;
                        for (WatchListViewItem viewItem : WatchListViewModel.this.items) {
                            column.getDataProvider().init((IAdaptable)viewItem);
                        }
                        PropertyChangeSupport propertyChangeSupport = WatchListViewModel.this.changeSupport;
                        boolean bl = WatchListViewModel.this.dirty;
                        WatchListViewModel.this.dirty = true;
                        propertyChangeSupport.firePropertyChange(WatchListViewModel.PROP_DIRTY, bl, true);
                    }

                    public void handleRemove(int index, Object element) {
                        WatchListViewColumn column = (WatchListViewColumn)element;
                        column.getDataProvider().dispose();
                        PropertyChangeSupport propertyChangeSupport = WatchListViewModel.this.changeSupport;
                        boolean bl = WatchListViewModel.this.dirty;
                        WatchListViewModel.this.dirty = true;
                        propertyChangeSupport.firePropertyChange(WatchListViewModel.PROP_DIRTY, bl, true);
                    }
                });
            }
        });
        pricingEnvironment.addPricingListener(this.pricingListener);
    }

    public void init() {
        WatchListViewColumn[] column = this.columns.toArray(new WatchListViewColumn[this.columns.size()]);
        int i = 0;
        while (i < column.length) {
            for (WatchListViewItem viewItem : this.items) {
                column[i].getDataProvider().init((IAdaptable)viewItem);
            }
            ++i;
        }
    }

    private void init(WatchListViewItem viewItem) {
        WatchListViewColumn[] column = this.columns.toArray(new WatchListViewColumn[this.columns.size()]);
        int i = 0;
        while (i < column.length) {
            column[i].getDataProvider().init((IAdaptable)viewItem);
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name != null && name != null && this.name.equals(name)) {
            return;
        }
        this.name = name;
        this.changeSupport.firePropertyChange(PROP_NAME, name, this.name);
        this.dirty = true;
        this.changeSupport.firePropertyChange(PROP_DIRTY, this.dirty, true);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.changeSupport.firePropertyChange(PROP_DIRTY, this.dirty, this.dirty);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void add(ISecurity security) {
        WatchListViewItem viewItem = new WatchListViewItem(this, (IWatchListElement)new WatchListElement(security, null, null, null));
        viewItem.setLastClose(this.pricingEnvironment.getLastClose(security));
        viewItem.setQuote(this.pricingEnvironment.getQuote(security));
        viewItem.setTrade(this.pricingEnvironment.getTrade(security));
        viewItem.setTodayOHL(this.pricingEnvironment.getTodayOHL(security));
        this.updateValues(viewItem);
        this.observableItems.add((Object)viewItem);
    }

    public void commit() {
        this.watchList.setName(this.name);
        IWatchListColumn[] c = new IWatchListColumn[this.columns.size()];
        int i = 0;
        while (i < c.length) {
            WatchListViewColumn viewColumn = this.columns.get(i);
            c[i] = viewColumn.getColumn();
            if (c[i] != null) {
                c[i].setName(viewColumn.getName());
            } else {
                c[i] = new WatchListColumn(viewColumn.getName(), viewColumn.getDataProviderFactory());
            }
            ++i;
        }
        this.watchList.setColumns(c);
        ArrayList<IWatchListElement> e = new ArrayList<IWatchListElement>();
        for (WatchListViewItem viewItem : this.items) {
            IWatchListElement element = viewItem.getElement();
            element.setPosition(viewItem.getPosition());
            element.setPurchasePrice(viewItem.getPurchasePrice());
            e.add(element);
        }
        this.watchList.setItems(e.toArray(new IWatchListElement[e.size()]));
    }

    public void dispose() {
        this.pricingEnvironment.removePricingListener(this.pricingListener);
    }

    public IWatchList getWatchList() {
        return this.watchList;
    }

    public List<WatchListViewColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<WatchListViewColumn> list) {
        int i = this.observableColumns.size() - 1;
        while (i >= 0) {
            if (!list.contains(this.observableColumns.get(i))) {
                this.observableColumns.remove(i);
            }
            --i;
        }
        i = 0;
        while (i < list.size()) {
            if (!this.observableColumns.contains((Object)list.get(i))) {
                this.observableColumns.add(i, (Object)list.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            int index = this.observableColumns.indexOf((Object)list.get(i));
            this.columns.get(index).setName(list.get(i).getName());
            if (index != i) {
                this.observableColumns.move(index, i);
                i = -1;
            }
            ++i;
        }
        this.update();
    }

    public WritableList getObservableColumns() {
        return this.observableColumns;
    }

    public WritableList getObservableItems() {
        return this.observableItems;
    }

    protected void doPricingUpdate(PricingEvent event) {
        PricingDelta[] delta = event.getDelta();
        double purchaseValue = 0.0;
        double marketValue = 0.0;
        for (WatchListViewItem viewItem : this.items) {
            GainValue gainValue;
            if (viewItem.getSecurity() == event.getSecurity()) {
                int i = 0;
                while (i < delta.length) {
                    viewItem.setPriceData(delta[i].getNewValue());
                    ++i;
                }
                this.updateValues(viewItem);
            }
            if ((gainValue = (GainValue)viewItem.getValue("org.eclipsetrader.ui.providers.gain")) == null) continue;
            purchaseValue += gainValue.getPurchaseValue().doubleValue();
            marketValue += gainValue.getMarketValue().doubleValue();
        }
        if (purchaseValue != 0.0) {
            Double value = marketValue - purchaseValue;
            Double percentage = value / purchaseValue * 100.0;
            String text = String.valueOf(value > 0.0 ? "+" : "") + this.formatter.format(value) + " (" + (value > 0.0 ? "+" : "") + this.percentageFormatter.format(percentage) + "%)";
            Color color = value != 0.0 ? (value > 0.0 ? this.positiveColor : this.negativeColor) : null;
            this.totalsItem.putValue("org.eclipsetrader.ui.providers.gain", new GainValue(value, purchaseValue, marketValue, text, color));
        }
    }

    public void update() {
        for (WatchListViewItem viewItem : this.items) {
            this.updateValues(viewItem);
        }
    }

    private void updateValues(WatchListViewItem item) {
        WatchListViewColumn[] column = this.columns.toArray(new WatchListViewColumn[this.columns.size()]);
        int i = 0;
        while (i < column.length) {
            IAdaptable value = column[i].getDataProvider().getValue((IAdaptable)item);
            item.putValue(column[i].getId(), value);
            ++i;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.pricingEnvironment.getClass())) {
            return this.pricingEnvironment;
        }
        return null;
    }
}

