/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.trading;

import java.text.NumberFormat;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipsetrader.core.trading.IOrderMonitor;

public class AveragePriceColumn
extends ColumnLabelProvider {
    public static final String COLUMN_ID = "org.eclipsetrader.ui.trading.orders.averageprice";
    private NumberFormat formatter = NumberFormat.getInstance();

    public AveragePriceColumn() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(1);
        this.formatter.setMaximumFractionDigits(4);
    }

    public String getText(Object element) {
        IOrderMonitor order;
        if (element instanceof IOrderMonitor && (order = (IOrderMonitor)element).getAveragePrice() != null) {
            return this.formatter.format(order.getAveragePrice());
        }
        return "";
    }

    public boolean isLabelProperty(Object element, String property) {
        return "averagePrice".equals(property);
    }
}

