/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.trading;

import java.text.NumberFormat;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipsetrader.core.trading.IOrderMonitor;

public class FilledQuantityColumn
extends ColumnLabelProvider {
    public static final String COLUMN_ID = "org.eclipsetrader.ui.trading.orders.filledqty";
    private NumberFormat formatter = NumberFormat.getInstance();

    public FilledQuantityColumn() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(0);
        this.formatter.setMaximumFractionDigits(0);
    }

    public String getText(Object element) {
        IOrderMonitor order;
        if (element instanceof IOrderMonitor && (order = (IOrderMonitor)element).getFilledQuantity() != null) {
            return this.formatter.format(order.getFilledQuantity());
        }
        return "";
    }

    public boolean isLabelProperty(Object element, String property) {
        return "filledQuantity".equals(property);
    }
}

