/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.trading;

import java.text.NumberFormat;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IOrderMonitor;

public class StopPriceColumn
extends ColumnLabelProvider {
    public static final String COLUMN_ID = "org.eclipsetrader.ui.trading.orders.stopprice";
    private NumberFormat formatter = NumberFormat.getInstance();

    public StopPriceColumn() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(1);
        this.formatter.setMaximumFractionDigits(4);
    }

    public String getText(Object element) {
        IOrder order = null;
        if (element instanceof IOrder) {
            order = (IOrder)element;
        } else if (element instanceof IOrderMonitor) {
            order = ((IOrderMonitor)element).getOrder();
        }
        if (order != null && order.getStopPrice() != null) {
            return this.formatter.format(order.getStopPrice());
        }
        return "";
    }
}

