/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.javascript;

import com.tictactec.ta.lib.Core;
import com.tictactec.ta.lib.MInteger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.ats.engines.BarsDataSeriesFunction;
import org.eclipsetrader.core.ats.engines.IndicatorFunction;
import org.eclipsetrader.core.charts.NumericDataSeries;
import org.eclipsetrader.ui.charts.MAType;
import org.eclipsetrader.ui.charts.OHLCField;
import org.eclipsetrader.ui.internal.charts.Util;
import org.eclipsetrader.ui.internal.charts.indicators.Activator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class STOCHRSI
extends IndicatorFunction {
    private static final long serialVersionUID = -9191442400382251716L;
    private OHLCField field = OHLCField.Close;
    private int kFastPeriod;
    private int kSlowPeriod;
    private int dPeriod = 14;
    private MAType dMaType = MAType.EMA;

    public STOCHRSI() {
    }

    public STOCHRSI(BarsDataSeriesFunction bars, int kFastPeriod, int kSlowPeriod) {
        super(bars);
        this.kFastPeriod = kFastPeriod;
        this.kSlowPeriod = kSlowPeriod;
        this.calculate();
    }

    public static Object jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        BarsDataSeriesFunction bars = (BarsDataSeriesFunction)ScriptableObject.getProperty((Scriptable)STOCHRSI.getTopLevelScope((Scriptable)ctorObj), (String)"bars");
        int kFastPeriod = (int)Context.toNumber((Object)args[0]);
        int kSlowPeriod = (int)Context.toNumber((Object)args[1]);
        STOCHRSI result = new STOCHRSI(bars, kFastPeriod, kSlowPeriod);
        return result;
    }

    protected void calculate() {
        Core core;
        int lookback;
        IAdaptable[] values = this.source.getValues();
        if (values.length < (lookback = (core = Activator.getDefault() != null ? Activator.getDefault().getCore() : new Core()).stochRsiLookback(this.kFastPeriod, this.kSlowPeriod, this.dPeriod, MAType.getTALib_MAType(this.dMaType)))) {
            this.series = new NumericDataSeries(this.getClassName(), new Number[0], this.source);
            return;
        }
        int startIdx = 0;
        int endIdx = values.length - 1;
        double[] inReal = Util.getValuesForField(values, this.field);
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        double[] outK = new double[values.length - lookback];
        double[] outD = new double[values.length - lookback];
        core.stochRsi(startIdx, endIdx, inReal, this.kFastPeriod, this.kSlowPeriod, this.dPeriod, MAType.getTALib_MAType(this.dMaType), outBegIdx, outNbElement, outK, outD);
        this.series = new NumericDataSeries(this.getClassName(), outK, this.source);
    }

    public Object jsFunction_crosses(IndicatorFunction other, Object bar) {
        return super.jsFunction_crosses(other, bar);
    }

    public Object jsFunction_first() {
        return super.jsFunction_first();
    }

    public Object jsFunction_last() {
        return super.jsFunction_last();
    }

    public Object jsFunction_highest() {
        return super.jsFunction_highest();
    }

    public Object jsFunction_lowest() {
        return super.jsFunction_lowest();
    }
}

