/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts.indicators;

import com.tictactec.ta.lib.Core;
import com.tictactec.ta.lib.MInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.NumericDataSeries;
import org.eclipsetrader.ui.charts.ChartParameters;
import org.eclipsetrader.ui.charts.GroupChartObject;
import org.eclipsetrader.ui.charts.HistogramAreaChart;
import org.eclipsetrader.ui.charts.HistogramBarChart;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.charts.LineChart;
import org.eclipsetrader.ui.charts.OHLCField;
import org.eclipsetrader.ui.charts.RenderStyle;
import org.eclipsetrader.ui.internal.charts.Util;
import org.eclipsetrader.ui.internal.charts.indicators.Activator;

public class AROON
implements IChartObjectFactory,
IExecutableExtension {
    private String id;
    private String factoryName;
    private String name;
    private int period = 7;
    private RenderStyle upLineStyle = RenderStyle.Line;
    private RGB upLineColor;
    private RenderStyle downLineStyle = RenderStyle.Line;
    private RGB downLineColor;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.factoryName = config.getAttribute("name");
        this.name = config.getAttribute("name");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public RenderStyle getUpperLineStyle() {
        return this.upLineStyle;
    }

    public void setUpperLineStyle(RenderStyle upperLineStyle) {
        this.upLineStyle = upperLineStyle;
    }

    public RGB getUpperLineColor() {
        return this.upLineColor;
    }

    public void setUpperLineColor(RGB upperLineColor) {
        this.upLineColor = upperLineColor;
    }

    public RenderStyle getMiddleLineStyle() {
        return this.downLineStyle;
    }

    public void setMiddleLineStyle(RenderStyle middleLineStyle) {
        this.downLineStyle = middleLineStyle;
    }

    public RGB getMiddleLineColor() {
        return this.downLineColor;
    }

    public void setMiddleLineColor(RGB middleLineColor) {
        this.downLineColor = middleLineColor;
    }

    public IChartObject createObject(IDataSeries source) {
        Core core;
        int lookback;
        if (source == null) {
            return null;
        }
        IAdaptable[] values = source.getValues();
        if (values.length < (lookback = (core = Activator.getDefault() != null ? Activator.getDefault().getCore() : new Core()).aroonLookback(this.period))) {
            return null;
        }
        int startIdx = 0;
        int endIdx = values.length - 1;
        double[] inHigh = Util.getValuesForField(values, OHLCField.High);
        double[] inLow = Util.getValuesForField(values, OHLCField.Low);
        MInteger outBegIdx = new MInteger();
        MInteger outNbElement = new MInteger();
        double[] outUp = new double[values.length - lookback];
        double[] outDown = new double[values.length - lookback];
        core.aroon(startIdx, endIdx, inHigh, inLow, this.period, outBegIdx, outNbElement, outUp, outDown);
        GroupChartObject object = new GroupChartObject();
        object.add(this.createLineChartObject((IDataSeries)new NumericDataSeries("AROON-U", outUp, source), this.upLineStyle, this.upLineColor));
        object.add(this.createLineChartObject((IDataSeries)new NumericDataSeries("AROON-D", outDown, source), this.downLineStyle, this.downLineColor));
        return object;
    }

    protected IChartObject createLineChartObject(IDataSeries result, RenderStyle renderStyle, RGB color) {
        LineChart.LineStyle lineStyle = LineChart.LineStyle.Solid;
        switch (renderStyle) {
            case Dash: {
                lineStyle = LineChart.LineStyle.Dash;
                break;
            }
            case Dot: {
                lineStyle = LineChart.LineStyle.Dot;
                break;
            }
            case HistogramBars: {
                return new HistogramBarChart(result);
            }
            case Histogram: {
                return new HistogramAreaChart(result, color);
            }
            case Invisible: {
                lineStyle = LineChart.LineStyle.Invisible;
            }
        }
        return new LineChart(result, lineStyle, color);
    }

    public IChartParameters getParameters() {
        ChartParameters parameters = new ChartParameters();
        if (!this.factoryName.equals(this.name)) {
            parameters.setParameter("name", this.name);
        }
        parameters.setParameter("period", (Number)this.period);
        parameters.setParameter("up-line-style", this.upLineStyle.getName());
        if (this.upLineColor != null) {
            parameters.setParameter("up-line-color", this.upLineColor);
        }
        parameters.setParameter("down-line-style", this.downLineStyle.getName());
        if (this.downLineColor != null) {
            parameters.setParameter("down-line-color", this.downLineColor);
        }
        return parameters;
    }

    public void setParameters(IChartParameters parameters) {
        this.name = parameters.hasParameter("name") ? parameters.getString("name") : this.factoryName;
        this.period = parameters.getInteger("period");
        this.upLineStyle = parameters.hasParameter("up-line-style") ? RenderStyle.getStyleFromName((String)parameters.getString("up-line-style")) : RenderStyle.Line;
        this.upLineColor = parameters.getColor("up-line-color");
        this.downLineStyle = parameters.hasParameter("down-line-style") ? RenderStyle.getStyleFromName((String)parameters.getString("down-line-style")) : RenderStyle.Line;
        this.downLineColor = parameters.getColor("down-line-color");
    }
}

