/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.charts.patterns;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.ui.charts.ChartParameters;
import org.eclipsetrader.ui.charts.GroupChartObject;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.IChartObjectFactory;
import org.eclipsetrader.ui.charts.IChartParameters;
import org.eclipsetrader.ui.charts.ILineDecorator;
import org.eclipsetrader.ui.charts.RenderStyle;
import org.eclipsetrader.ui.charts.patterns.Messages;
import org.eclipsetrader.ui.internal.charts.PatternBox;
import org.eclipsetrader.ui.internal.charts.indicators.IGeneralPropertiesAdapter;

public class KeyReversal
implements IChartObjectFactory,
IGeneralPropertiesAdapter,
ILineDecorator,
IExecutableExtension {
    private String id;
    private String factoryName;
    private String name;
    private RenderStyle renderStyle = RenderStyle.Line;
    private RGB color;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.factoryName = config.getAttribute("name");
        this.name = config.getAttribute("name");
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public RenderStyle getRenderStyle() {
        return this.renderStyle;
    }

    @Override
    public void setRenderStyle(RenderStyle renderStyle) {
        this.renderStyle = renderStyle;
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    public IChartObject createObject(IDataSeries source) {
        if (source == null) {
            return null;
        }
        IAdaptable[] values = source.getValues();
        if (values.length < 2) {
            return null;
        }
        GroupChartObject object = new GroupChartObject();
        int i = values.length - 2;
        while (i >= 0) {
            IOHLC[] iOHLCArray = new IOHLC[]{(IOHLC)values[i].getAdapter(IOHLC.class), (IOHLC)values[i + 1].getAdapter(IOHLC.class)};
            IOHLC[] outBars = iOHLCArray;
            if (outBars[0].getHigh() < outBars[1].getHigh() && outBars[0].getLow() > outBars[1].getLow()) {
                if (outBars[1].getClose() >= outBars[0].getHigh()) {
                    object.add((IChartObject)new PatternBox(outBars, this.color, this.getName(), Messages.Bullish));
                    i -= outBars.length;
                } else if (outBars[1].getClose() <= outBars[0].getLow()) {
                    object.add((IChartObject)new PatternBox(outBars, this.color, this.getName(), Messages.Bearish));
                    i -= outBars.length;
                }
            }
            --i;
        }
        return object;
    }

    public IChartParameters getParameters() {
        ChartParameters parameters = new ChartParameters();
        if (!this.factoryName.equals(this.name)) {
            parameters.setParameter("name", this.name);
        }
        parameters.setParameter("style", this.renderStyle.getName());
        if (this.color != null) {
            parameters.setParameter("color", this.color);
        }
        return parameters;
    }

    public void setParameters(IChartParameters parameters) {
        this.name = parameters.hasParameter("name") ? parameters.getString("name") : this.factoryName;
        this.renderStyle = parameters.hasParameter("style") ? RenderStyle.getStyleFromName((String)parameters.getString("style")) : RenderStyle.Line;
        this.color = parameters.getColor("color");
    }
}

