/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.ui.charts.HistogramAreaChart;
import org.eclipsetrader.ui.charts.HistogramBarChart;
import org.eclipsetrader.ui.charts.IChartObject;
import org.eclipsetrader.ui.charts.LineChart;
import org.eclipsetrader.ui.charts.OHLCField;
import org.eclipsetrader.ui.charts.RenderStyle;

public class Util {
    private Util() {
    }

    public static double[] getValuesForField(IAdaptable[] values, OHLCField field) {
        double[] inReal = new double[values.length];
        switch (field) {
            case Open: {
                int i = 0;
                while (i < values.length) {
                    IOHLC ohlc = (IOHLC)values[i].getAdapter(IOHLC.class);
                    if (ohlc != null) {
                        inReal[i] = ohlc.getOpen();
                    } else {
                        Number number = (Number)values[i].getAdapter(Number.class);
                        inReal[i] = number.doubleValue();
                    }
                    ++i;
                }
                break;
            }
            case High: {
                int i = 0;
                while (i < values.length) {
                    IOHLC ohlc = (IOHLC)values[i].getAdapter(IOHLC.class);
                    if (ohlc != null) {
                        inReal[i] = ohlc.getHigh();
                    } else {
                        Number number = (Number)values[i].getAdapter(Number.class);
                        inReal[i] = number.doubleValue();
                    }
                    ++i;
                }
                break;
            }
            case Low: {
                int i = 0;
                while (i < values.length) {
                    IOHLC ohlc = (IOHLC)values[i].getAdapter(IOHLC.class);
                    if (ohlc != null) {
                        inReal[i] = ohlc.getLow();
                    } else {
                        Number number = (Number)values[i].getAdapter(Number.class);
                        inReal[i] = number.doubleValue();
                    }
                    ++i;
                }
                break;
            }
            case Close: {
                int i = 0;
                while (i < values.length) {
                    IOHLC ohlc = (IOHLC)values[i].getAdapter(IOHLC.class);
                    if (ohlc != null) {
                        inReal[i] = ohlc.getClose();
                    } else {
                        Number number = (Number)values[i].getAdapter(Number.class);
                        inReal[i] = number.doubleValue();
                    }
                    ++i;
                }
                break;
            }
            case Volume: {
                int i = 0;
                while (i < values.length) {
                    IOHLC ohlc = (IOHLC)values[i].getAdapter(IOHLC.class);
                    if (ohlc != null) {
                        inReal[i] = ohlc.getVolume().longValue();
                    } else {
                        Number number = (Number)values[i].getAdapter(Number.class);
                        inReal[i] = number.doubleValue();
                    }
                    ++i;
                }
                break;
            }
        }
        return inReal;
    }

    public static IChartObject createLineChartObject(IDataSeries result, RenderStyle renderStyle, RGB color) {
        LineChart.LineStyle lineStyle = LineChart.LineStyle.Solid;
        switch (renderStyle) {
            case Dash: {
                lineStyle = LineChart.LineStyle.Dash;
                break;
            }
            case Dot: {
                lineStyle = LineChart.LineStyle.Dot;
                break;
            }
            case HistogramBars: {
                return new HistogramBarChart(result);
            }
            case Histogram: {
                return new HistogramAreaChart(result, color);
            }
            case Invisible: {
                lineStyle = LineChart.LineStyle.Invisible;
            }
        }
        return new LineChart(result, lineStyle, color);
    }
}

