/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.indicators;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.ui.charts.indicators.SAR;
import org.eclipsetrader.ui.internal.charts.indicators.Messages;

public class SARPropertiesPage
extends PropertyPage {
    private Spinner acceleration;
    private Spinner maximum;

    public SARPropertiesPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle(Messages.ParabolicSAR);
        Label label = new Label(content, 0);
        label.setText(Messages.Acceleration);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(75), -1));
        this.acceleration = new Spinner(content, 2048);
        this.acceleration.setValues(2, 1, 99999, 2, 1, 10);
        label = new Label(content, 0);
        label.setText(Messages.Maximum);
        this.maximum = new Spinner(content, 2048);
        this.maximum.setValues(20, 1, 99999, 2, 1, 10);
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        SAR object = (SAR)this.getElement().getAdapter(SAR.class);
        this.acceleration.setSelection((int)(object.getAcceleration() * Math.pow(10.0, this.acceleration.getDigits())));
        this.maximum.setSelection((int)(object.getMaximum() * Math.pow(10.0, this.maximum.getDigits())));
        super.performDefaults();
    }

    public boolean performOk() {
        SAR object = (SAR)this.getElement().getAdapter(SAR.class);
        object.setAcceleration((double)this.acceleration.getSelection() / Math.pow(10.0, this.acceleration.getDigits()));
        object.setMaximum((double)this.maximum.getSelection() / Math.pow(10.0, this.maximum.getDigits()));
        return super.performOk();
    }
}

