/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.charts.indicators;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.ui.charts.IObjectRenderer;
import org.eclipsetrader.ui.charts.LineRenderers;
import org.eclipsetrader.ui.charts.RenderStyle;
import org.eclipsetrader.ui.charts.RenderTarget;

public class SingleLineElement
implements IAdaptable,
IObjectRenderer {
    private IDataSeries dataSeries;
    private RenderStyle style;
    private RGB color = new RGB(0, 0, 0);

    public SingleLineElement() {
    }

    public SingleLineElement(IDataSeries dataSeries, RenderStyle style, RGB color) {
        this.dataSeries = dataSeries;
        this.style = style;
        this.color = color;
    }

    public void renderObject(RenderTarget target, IDataSeries dataSeries) {
        Color color = target.registry.getColor(this.color);
        switch (this.style) {
            case Dot: {
                LineRenderers.renderDotLine((RenderTarget)target, (IAdaptable[])dataSeries.getValues(), (Color)color);
                break;
            }
            case Dash: {
                LineRenderers.renderDashLine((RenderTarget)target, (IAdaptable[])dataSeries.getValues(), (Color)color);
                break;
            }
            case HistogramBars: {
                LineRenderers.renderHistogramBars((RenderTarget)target, (IAdaptable[])dataSeries.getValues(), (int)3, (Color)color);
                break;
            }
            default: {
                LineRenderers.renderLine((RenderTarget)target, (IAdaptable[])dataSeries.getValues(), (Color)color);
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IDataSeries.class)) {
            return this.dataSeries;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }
}

