/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipsetrader.repository.local.internal.stores.ScriptStore;

@XmlRootElement(name="list")
public class ScriptsCollection {
    private static ScriptsCollection instance;
    @XmlAttribute(name="next_id")
    private Integer nextId = new Integer(1);
    @XmlElementRef
    private List<ScriptStore> list;
    private Map<URI, ScriptStore> uriMap;

    public ScriptsCollection() {
        instance = this;
        this.list = new ArrayList<ScriptStore>();
    }

    public static ScriptsCollection getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptStore get(URI uri) {
        ScriptsCollection scriptsCollection = this;
        synchronized (scriptsCollection) {
            if (this.uriMap == null) {
                this.uriMap = new HashMap<URI, ScriptStore>();
                for (ScriptStore store : this.list) {
                    this.uriMap.put(store.toURI(), store);
                }
            }
        }
        return this.uriMap.get(uri);
    }

    public ScriptStore create() {
        ScriptStore securityStore = new ScriptStore(this.nextId);
        this.list.add(securityStore);
        if (this.uriMap != null) {
            this.uriMap.put(securityStore.toURI(), securityStore);
        }
        this.nextId = new Integer(this.nextId + 1);
        return securityStore;
    }

    public void delete(ScriptStore tradeStore) {
        Iterator<ScriptStore> iter = this.list.iterator();
        while (iter.hasNext()) {
            if (iter.next() != tradeStore) continue;
            iter.remove();
            if (this.uriMap == null) break;
            this.uriMap.remove(tradeStore.toURI());
            break;
        }
    }

    public ScriptStore[] getAll() {
        return this.list.toArray(new ScriptStore[this.list.size()]);
    }

    public List<ScriptStore> getList() {
        return this.list;
    }

    public ScriptStore[] toArray() {
        return this.list.toArray(new ScriptStore[this.list.size()]);
    }
}

