/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipsetrader.repository.local.internal.stores.TradeStore;

@XmlRootElement(name="list")
public class TradeCollection {
    private static TradeCollection instance;
    @XmlAttribute(name="next_id")
    private Integer nextId = new Integer(1);
    @XmlElementRef
    private List<TradeStore> list;
    private Map<URI, TradeStore> uriMap;

    public TradeCollection() {
        instance = this;
        this.list = new ArrayList<TradeStore>();
    }

    public static TradeCollection getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TradeStore get(URI uri) {
        TradeCollection tradeCollection = this;
        synchronized (tradeCollection) {
            if (this.uriMap == null) {
                this.uriMap = new HashMap<URI, TradeStore>();
                for (TradeStore securityStore : this.list) {
                    this.uriMap.put(securityStore.toURI(), securityStore);
                }
            }
        }
        return this.uriMap.get(uri);
    }

    public TradeStore create() {
        TradeStore securityStore = new TradeStore(this.nextId);
        this.list.add(securityStore);
        if (this.uriMap != null) {
            this.uriMap.put(securityStore.toURI(), securityStore);
        }
        this.nextId = new Integer(this.nextId + 1);
        return securityStore;
    }

    public void delete(TradeStore tradeStore) {
        Iterator<TradeStore> iter = this.list.iterator();
        while (iter.hasNext()) {
            if (iter.next() != tradeStore) continue;
            iter.remove();
            if (this.uriMap == null) break;
            this.uriMap.remove(tradeStore.toURI());
            break;
        }
    }

    public TradeStore[] getAll() {
        return this.list.toArray(new TradeStore[this.list.size()]);
    }

    public List<TradeStore> getList() {
        return this.list;
    }

    public TradeStore[] toArray() {
        return this.list.toArray(new TradeStore[this.list.size()]);
    }
}

