/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.stores;

import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.repositories.StoreProperties;
import org.eclipsetrader.repository.local.LocalRepository;
import org.eclipsetrader.repository.local.internal.Activator;
import org.eclipsetrader.repository.local.internal.types.HistoryType;

public class LazyStoreProperties
extends StoreProperties {
    private Integer id;

    public LazyStoreProperties(Integer id) {
        this.id = id;
    }

    public Object getProperty(String name) {
        if (("bars".equals(name) || "splits".equals(name)) && this.getProperties().get(name) == null) {
            IPath path = LocalRepository.getInstance().getLocation().append(".history");
            path.toFile().mkdirs();
            HistoryType historyType = (HistoryType)this.unmarshal(HistoryType.class, path.append(String.valueOf(String.valueOf(this.id)) + ".xml").toFile());
            if (historyType != null) {
                this.getProperties().put("bars", historyType.toArray());
                this.getProperties().put("splits", historyType.getSplits());
            }
        }
        return super.getProperty(name);
    }

    protected Object unmarshal(Class clazz, File file) {
        try {
            if (file.exists()) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                unmarshaller.setEventHandler(new ValidationEventHandler(){

                    public boolean handleEvent(ValidationEvent event) {
                        Status status = new Status(2, "org.eclipsetrader.repository.local", 0, "Error validating XML: " + event.getMessage(), null);
                        Activator.getDefault().getLog().log((IStatus)status);
                        return true;
                    }
                });
                return unmarshaller.unmarshal(file);
            }
        }
        catch (Exception exception) {
            Status status = new Status(2, "org.eclipsetrader.repository.local", 0, "Error loading identifiers", null);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return null;
    }
}

