/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.stores;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryElementFactory;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.repositories.StoreProperties;
import org.eclipsetrader.repository.local.internal.Activator;
import org.eclipsetrader.repository.local.internal.ScriptsCollection;
import org.eclipsetrader.repository.local.internal.types.RepositoryFactoryAdapter;

@XmlRootElement(name="script")
public class ScriptStore
implements IStore {
    @XmlAttribute(name="id")
    private Integer id;
    @XmlAttribute(name="factory")
    @XmlJavaTypeAdapter(value=RepositoryFactoryAdapter.class)
    private IRepositoryElementFactory factory;
    @XmlAttribute(name="type")
    private String type;
    @XmlAttribute(name="language")
    private String language;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="text")
    private String text;

    public ScriptStore() {
    }

    public ScriptStore(Integer id) {
        this.id = id;
    }

    public IStoreProperties fetchProperties(IProgressMonitor monitor) {
        StoreProperties properties = new StoreProperties();
        if (this.factory != null) {
            properties.setProperty("factory", (Object)this.factory);
        }
        properties.setProperty("type", (Object)this.type);
        properties.setProperty("name", (Object)this.name);
        properties.setProperty("language", (Object)this.language);
        properties.setProperty("text", (Object)this.text);
        return properties;
    }

    public void putProperties(IStoreProperties properties, IProgressMonitor monitor) {
        this.factory = (IRepositoryElementFactory)properties.getProperty("factory");
        this.type = (String)properties.getProperty("type");
        this.name = (String)properties.getProperty("name");
        this.language = (String)properties.getProperty("language");
        this.text = (String)properties.getProperty("text");
    }

    public void delete(IProgressMonitor monitor) throws CoreException {
        ScriptsCollection.getInstance().delete(this);
    }

    public IStore[] fetchChilds(IProgressMonitor monitor) {
        return null;
    }

    public IStore createChild() {
        return null;
    }

    @XmlTransient
    public IRepository getRepository() {
        return Activator.getDefault().getRepository();
    }

    public URI toURI() {
        try {
            return new URI("local", "scripts", String.valueOf(this.id));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

