/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.types;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.repository.local.internal.Activator;

public class DataProviderFactoryAdapter
extends XmlAdapter<String, IDataProviderFactory> {
    public static final String PROVIDERS_FACTORY_ID = "org.eclipsetrader.core.providers";

    public String marshal(IDataProviderFactory v) throws Exception {
        return v != null ? v.getId() : null;
    }

    public IDataProviderFactory unmarshal(String v) throws Exception {
        return v != null ? this.getFactory(v) : null;
    }

    protected IDataProviderFactory getFactory(String id) {
        IConfigurationElement[] configElements = this.getConfigurationElements();
        if (configElements == null) {
            return null;
        }
        int j = 0;
        while (j < configElements.length) {
            String strID = configElements[j].getAttribute("id");
            if (id.equals(strID)) {
                try {
                    IDataProviderFactory factory = (IDataProviderFactory)configElements[j].createExecutableExtension("class");
                    return factory;
                }
                catch (Exception e) {
                    Status status = new Status(2, "org.eclipsetrader.repository.local", 0, "Unable to create data provider factory with id " + id, (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                    break;
                }
            }
            ++j;
        }
        Status status = new Status(2, "org.eclipsetrader.repository.local", 0, "Failed to load provider " + id, null);
        Activator.getDefault().getLog().log((IStatus)status);
        return new FailsafeDataProviderFactory(id);
    }

    protected IConfigurationElement[] getConfigurationElements() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PROVIDERS_FACTORY_ID);
        if (extensionPoint == null) {
            return null;
        }
        return extensionPoint.getConfigurationElements();
    }

    public class FailsafeDataProviderFactory
    implements IDataProviderFactory {
        private String id;

        public FailsafeDataProviderFactory(String id) {
            this.id = id;
        }

        public IDataProvider createProvider() {
            return null;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.id;
        }

        public Class[] getType() {
            return new Class[0];
        }
    }
}

