/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.types;

import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.feed.Dividend;
import org.eclipsetrader.core.feed.IDividend;
import org.eclipsetrader.repository.local.internal.types.DateAdapter;
import org.eclipsetrader.repository.local.internal.types.DoubleValueAdapter;
import org.eclipsetrader.repository.local.internal.types.SplitType;

@XmlRootElement(name="dividend")
public class DividendType
implements Comparable<Object> {
    @XmlAttribute(name="ex-date")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date exDate;
    @XmlAttribute(name="value")
    @XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
    private Double value;

    public DividendType() {
    }

    public DividendType(IDividend dividend) {
        this.exDate = dividend.getExDate();
        this.value = dividend.getValue();
    }

    public IDividend getDividend() {
        return new Dividend(this.exDate, this.value.doubleValue());
    }

    public Date getExDate() {
        return this.exDate;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof DividendType) {
            return this.exDate.compareTo(((DividendType)o).getExDate());
        }
        if (o instanceof SplitType) {
            return this.exDate.compareTo(((SplitType)o).getDate());
        }
        return 0;
    }
}

