/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.types;

import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.repository.local.internal.types.DateAdapter;
import org.eclipsetrader.repository.local.internal.types.HistoryType;
import org.eclipsetrader.repository.local.internal.types.SecurityAdapter;

@XmlRootElement(name="day")
public class HistoryDayType {
    @XmlAttribute(name="security")
    @XmlJavaTypeAdapter(value=SecurityAdapter.class)
    private ISecurity security;
    @XmlAttribute(name="date")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date date;
    @XmlElementRef
    private Set<HistoryType> periods = new TreeSet<HistoryType>();

    HistoryDayType() {
    }

    public HistoryDayType(ISecurity security, Date date) {
        this.security = security;
        this.date = date;
    }

    public void addHistory(HistoryType historyType) {
        Iterator<HistoryType> iter = this.periods.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getPeriod().equals((Object)historyType.getPeriod())) continue;
            iter.remove();
        }
        this.periods.add(historyType);
    }

    public void removeHistory(HistoryType historyType) {
        Iterator<HistoryType> iter = this.periods.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getPeriod().equals((Object)historyType.getPeriod())) continue;
            iter.remove();
        }
    }

    public void removeHistory(TimeSpan timeSpan) {
        Iterator<HistoryType> iter = this.periods.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getPeriod().equals((Object)timeSpan)) continue;
            iter.remove();
        }
    }

    public void removeAll() {
        this.periods.clear();
    }

    @XmlTransient
    public ISecurity getSecurity() {
        return this.security;
    }

    @XmlTransient
    public Date getDate() {
        return this.date;
    }

    @XmlTransient
    public HistoryType[] getPeriods() {
        return this.periods.toArray(new HistoryType[this.periods.size()]);
    }

    public HistoryType getPeriod(TimeSpan period) {
        for (HistoryType type : this.periods) {
            if (type.getPeriod() != period) continue;
            return type;
        }
        return null;
    }
}

