/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.ISplit;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.repository.local.internal.types.OHLCAdapter;
import org.eclipsetrader.repository.local.internal.types.SplitAdapter;
import org.eclipsetrader.repository.local.internal.types.TimeSpanAdapter;

@XmlRootElement(name="history")
public class HistoryType
implements Comparable<HistoryType> {
    @XmlTransient
    private ISecurity security;
    @XmlAttribute(name="period")
    @XmlJavaTypeAdapter(value=TimeSpanAdapter.class)
    private TimeSpan period;
    @XmlElementRef
    @XmlJavaTypeAdapter(value=OHLCAdapter.class)
    List<IOHLC> data = new ArrayList<IOHLC>();
    @XmlElementRef
    @XmlJavaTypeAdapter(value=SplitAdapter.class)
    List<ISplit> splits = new ArrayList<ISplit>();

    public HistoryType() {
    }

    public HistoryType(ISecurity security, IOHLC[] data) {
        this(security, data, null, null);
    }

    public HistoryType(ISecurity security, IOHLC[] data, TimeSpan period) {
        this(security, data, null, period);
    }

    public HistoryType(ISecurity security, IOHLC[] data, ISplit[] splits, TimeSpan period) {
        this.security = security;
        if (data != null) {
            this.data = new ArrayList<IOHLC>(Arrays.asList(data));
        }
        if (splits != null) {
            this.splits = new ArrayList<ISplit>(Arrays.asList(splits));
        }
        this.period = period;
    }

    @XmlTransient
    public List<IOHLC> getData() {
        return this.data;
    }

    public IOHLC[] toArray() {
        return this.data.toArray(new IOHLC[this.data.size()]);
    }

    public ISecurity getSecurity() {
        return this.security;
    }

    public TimeSpan getPeriod() {
        return this.period;
    }

    public ISplit[] getSplits() {
        return this.splits.toArray(new ISplit[this.splits.size()]);
    }

    @Override
    public int compareTo(HistoryType o) {
        if (this.period.getUnits() == o.period.getUnits()) {
            return this.period.getLength() - o.period.getLength();
        }
        return this.period.getUnits().ordinal() - o.period.getUnits().ordinal();
    }
}

