/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.types;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipsetrader.core.feed.FeedIdentifier;
import org.eclipsetrader.core.feed.FeedProperties;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.feed.IFeedProperties;
import org.eclipsetrader.repository.local.internal.types.PropertyType;

@XmlRootElement(name="identifier")
public class IdentifierType
implements Comparable<IdentifierType> {
    @XmlAttribute(name="symbol")
    private String symbol;
    @XmlElementWrapper(name="properties")
    @XmlElementRef
    private List<PropertyType> properties;
    private IFeedIdentifier identifier;

    public IdentifierType() {
    }

    public IdentifierType(String symbol) {
        this.symbol = symbol;
    }

    public IdentifierType(IFeedIdentifier identifier) {
        this.identifier = identifier;
        this.symbol = identifier.getSymbol();
        IFeedProperties feedProperties = (IFeedProperties)identifier.getAdapter(IFeedProperties.class);
        if (feedProperties != null) {
            this.properties = new ArrayList<PropertyType>();
            String[] stringArray = feedProperties.getPropertyIDs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.properties.add(new PropertyType(name, feedProperties.getProperty(name)));
                ++n2;
            }
        }
    }

    @XmlTransient
    public IFeedIdentifier getIdentifier() {
        if (this.identifier == null) {
            FeedProperties feedProperties = null;
            if (this.properties != null) {
                feedProperties = new FeedProperties();
                for (PropertyType type : this.properties) {
                    feedProperties.setProperty(type.getName(), type.getValue());
                }
            }
            this.identifier = new FeedIdentifier(this.symbol, feedProperties);
        }
        return this.identifier;
    }

    @XmlTransient
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public int compareTo(IdentifierType o) {
        return this.getSymbol().compareTo(o.getSymbol());
    }
}

