/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.types;

import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.OHLC;
import org.eclipsetrader.repository.local.internal.types.DateTimeAdapter;
import org.eclipsetrader.repository.local.internal.types.DoubleValueAdapter;

@XmlRootElement(name="bar")
public class OHLCType {
    @XmlAttribute(name="date")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date date;
    @XmlAttribute(name="open")
    @XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
    private Double open;
    @XmlAttribute(name="high")
    @XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
    private Double high;
    @XmlAttribute(name="low")
    @XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
    private Double low;
    @XmlAttribute(name="close")
    @XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
    private Double close;
    @XmlAttribute(name="volume")
    private Long volume;

    public OHLCType() {
    }

    public OHLCType(IOHLC ohlc) {
        this.date = ohlc.getDate();
        this.open = ohlc.getOpen();
        this.high = ohlc.getHigh();
        this.low = ohlc.getLow();
        this.close = ohlc.getClose();
        this.volume = ohlc.getVolume();
    }

    public IOHLC getOHLC() {
        return new OHLC(this.date, this.open, this.high, this.low, this.close, this.volume);
    }
}

