/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.repository.local.internal.types;

import java.net.URI;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.IScript;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.repository.local.internal.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ScriptAdapter
extends XmlAdapter<String, IScript> {
    private static IRepositoryService repositoryService;

    public static void setRepositoryService(IRepositoryService service) {
        repositoryService = service;
    }

    public String marshal(IScript v) throws Exception {
        if (v == null) {
            return null;
        }
        IStoreObject storeObject = (IStoreObject)v.getAdapter(IStoreObject.class);
        return storeObject.getStore().toURI().toString();
    }

    public IScript unmarshal(String v) throws Exception {
        IStoreObject result;
        Status status;
        if (v == null) {
            return null;
        }
        URI uri = new URI(v);
        if (repositoryService == null && Activator.getDefault() != null) {
            try {
                BundleContext context = Activator.getDefault().getBundle().getBundleContext();
                ServiceReference serviceReference = context.getServiceReference(IRepositoryService.class.getName());
                repositoryService = (IRepositoryService)context.getService(serviceReference);
                context.ungetService(serviceReference);
            }
            catch (Exception e) {
                status = new Status(4, "org.eclipsetrader.repository.local", 0, "Error reading repository service", (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        IStoreObject iStoreObject = result = repositoryService != null ? repositoryService.getObjectFromURI(uri) : null;
        if (!(result instanceof IScript)) {
            if (Activator.getDefault() != null) {
                status = new Status(2, "org.eclipsetrader.repository.local", 0, "Failed to load script " + uri.toString(), null);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            return new FailsafeScript(uri);
        }
        return (IScript)result;
    }

    public class FailsafeScript
    implements IScript,
    IStoreObject,
    IStore {
        private URI uri;

        public FailsafeScript(URI uri) {
            this.uri = uri;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public IStoreProperties fetchProperties(IProgressMonitor monitor) {
            return null;
        }

        public void putProperties(IStoreProperties properties, IProgressMonitor monitor) {
        }

        public void delete(IProgressMonitor monitor) throws CoreException {
        }

        public IStore[] fetchChilds(IProgressMonitor monitor) {
            return null;
        }

        public IStore createChild() {
            return null;
        }

        public IRepository getRepository() {
            return null;
        }

        public IStore getStore() {
            return null;
        }

        public void setStore(IStore store) {
        }

        public IStoreProperties getStoreProperties() {
            return null;
        }

        public void setStoreProperties(IStoreProperties storeProperties) {
        }

        public String getName() {
            return null;
        }

        public String getLanguage() {
            return null;
        }

        public String getText() {
            return null;
        }

        public URI toURI() {
            return this.uri;
        }
    }
}

