/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.news.internal;

import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.news.core.INewsService;
import org.eclipsetrader.news.internal.NewsService;
import org.eclipsetrader.news.internal.NewsServiceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipsetrader.news";
    public static final String PROVIDER_EXTENSION_POINT = "org.eclipsetrader.news.providers";
    public static final String PREFS_UPDATE_INTERVAL = "UPDATE_INTERVAL";
    public static final String PREFS_DATE_RANGE = "DATE_RANGE";
    public static final String PREFS_FOLLOW_QUOTE_FEED = "FOLLOW_QUOTE_FEED";
    public static final String PREFS_ENABLE_DECORATORS = "ENABLE_DECORATORS";
    private static Activator plugin;
    private NewsServiceFactory newsServiceFactory;
    private ServiceRegistration newsServiceRegistration;
    private IRepositoryService repositoryService;
    private ServiceReference repositoryServiceReference;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ServiceReference serviceReference = context.getServiceReference(IRepositoryService.class.getName());
        context.getService(serviceReference);
        context.ungetService(serviceReference);
        this.newsServiceFactory = new NewsServiceFactory();
        this.newsServiceRegistration = context.registerService(new String[]{INewsService.class.getName(), NewsService.class.getName()}, (Object)this.newsServiceFactory, new Hashtable());
        this.repositoryServiceReference = context.getServiceReference(IRepositoryService.class.getName());
        if (this.repositoryServiceReference != null) {
            this.repositoryService = (IRepositoryService)context.getService(this.repositoryServiceReference);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.newsServiceFactory != null && this.newsServiceFactory.getServiceInstance() != null) {
            this.newsServiceFactory.getServiceInstance().shutDown(null);
        }
        if (this.newsServiceRegistration != null) {
            this.newsServiceRegistration.unregister();
        }
        if (this.repositoryServiceReference != null) {
            context.ungetService(this.repositoryServiceReference);
            this.repositoryService = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put("readed_ovr", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/ovr16/readed_ovr.gif")));
        reg.put("unreaded_ovr", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/ovr16/unreaded_ovr.gif")));
        reg.put("normal_icon", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/eview16/headlines.png")));
        reg.put("new_headlines_icon", ImageDescriptor.createFromURL((URL)this.getBundle().getResource("icons/eview16/headlines_unread.png")));
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public IRepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public IDialogSettings getDialogSettingsForView(URI uri) {
        String uriString = uri.toString();
        IDialogSettings rootSettings = this.getDialogSettings().getSection("Views");
        if (rootSettings == null) {
            rootSettings = this.getDialogSettings().addNewSection("Views");
        }
        IDialogSettings[] sections = rootSettings.getSections();
        int i = 0;
        while (i < sections.length) {
            if (uriString.equals(sections[i].get("uri"))) {
                return sections[i];
            }
            ++i;
        }
        String uuid = UUID.randomUUID().toString();
        IDialogSettings dialogSettings = rootSettings.addNewSection(uuid);
        dialogSettings.put("uri", uriString);
        return dialogSettings;
    }
}

