/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.news.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.news.core.HeadLineStatus;
import org.eclipsetrader.news.core.IHeadLine;
import org.eclipsetrader.news.core.INewsProvider;
import org.eclipsetrader.news.core.INewsService;
import org.eclipsetrader.news.core.INewsServiceListener;
import org.eclipsetrader.news.core.INewsServiceRunnable;
import org.eclipsetrader.news.core.NewsEvent;
import org.eclipsetrader.news.internal.Activator;
import org.eclipsetrader.news.internal.repository.HeadLine;

public class NewsService
implements INewsService,
ISchedulingRule {
    public static final String HEADLINES_FILE = "headlines.xml";
    private List<IHeadLine> headLines = new ArrayList<IHeadLine>();
    private Map<ISecurity, List<IHeadLine>> securityMap = new HashMap<ISecurity, List<IHeadLine>>();
    private ListenerList listeners = new ListenerList(1);
    private List<HeadLineStatus> status = new ArrayList<HeadLineStatus>();
    private boolean holdNotifications;
    private List<INewsProvider> providers = new ArrayList<INewsProvider>();
    private IJobManager jobManager = Job.getJobManager();
    private final ILock lock = this.jobManager.newLock();

    public void startUp(IProgressMonitor monitor) throws JAXBException {
        File file = Activator.getDefault().getStateLocation().append(HEADLINES_FILE).toFile();
        if (file.exists()) {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{HeadLine[].class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    Status status = new Status(2, "org.eclipsetrader.news", 0, "Error validating XML: " + event.getMessage(), null);
                    Activator.getDefault().getLog().log((IStatus)status);
                    return true;
                }
            });
            JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(file), HeadLine[].class);
            this.headLines.addAll(Arrays.asList((HeadLine[])element.getValue()));
        }
        IConfigurationElement[] elements = this.getProvidersConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            try {
                INewsProvider newsProvider = (INewsProvider)elements[i].createExecutableExtension("class");
                this.headLines.addAll(Arrays.asList(newsProvider.getHeadLines()));
                this.providers.add(newsProvider);
            }
            catch (Exception exception) {}
            ++i;
        }
        Date limitDate = this.getLimitDate();
        Iterator<IHeadLine> iter = this.headLines.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getDate().before(limitDate)) continue;
            iter.remove();
        }
        this.updateSecurityMap();
    }

    public void shutDown(IProgressMonitor monitor) throws JAXBException, IOException {
        for (INewsProvider newsProvider : this.providers) {
            newsProvider.stop();
        }
        File file = Activator.getDefault().getStateLocation().append(HEADLINES_FILE).toFile();
        if (file.exists()) {
            file.delete();
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{HeadLine[].class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                Status status = new Status(2, "org.eclipsetrader.news", 0, "Error validating XML: " + event.getMessage(), null);
                Activator.getDefault().getLog().log((IStatus)status);
                return true;
            }
        });
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)System.getProperty("file.encoding"));
        ArrayList<HeadLine> list = new ArrayList<HeadLine>();
        for (IHeadLine h : this.headLines) {
            if (!(h instanceof HeadLine)) continue;
            list.add((HeadLine)h);
        }
        JAXBElement element = new JAXBElement(new QName("list"), HeadLine[].class, (Object)list.toArray(new HeadLine[list.size()]));
        marshaller.marshal((Object)element, (Writer)new FileWriter(file));
    }

    @Override
    public IHeadLine[] getHeadLines() {
        return this.headLines.toArray(new IHeadLine[this.headLines.size()]);
    }

    @Override
    public IHeadLine[] getHeadLinesFor(ISecurity security) {
        List<IHeadLine> l = this.securityMap.get(security);
        return l != null ? l.toArray(new IHeadLine[l.size()]) : new IHeadLine[]{};
    }

    @Override
    public boolean hasHeadLinesFor(ISecurity security) {
        List<IHeadLine> l = this.securityMap.get(security);
        return l != null && l.size() != 0;
    }

    @Override
    public boolean hasUnreadedHeadLinesFor(ISecurity security) {
        List<IHeadLine> l = this.securityMap.get(security);
        if (l != null) {
            for (IHeadLine h : l) {
                if (h.isReaded()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addNewsServiceListener(INewsServiceListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeNewsServiceListener(INewsServiceListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHeadLines(IHeadLine[] newHeadLines) {
        List<HeadLineStatus> list = this.status;
        synchronized (list) {
            Date limitDate = this.getLimitDate();
            int i = 0;
            while (i < newHeadLines.length) {
                if (!newHeadLines[i].getDate().before(limitDate) && !this.headLines.contains(newHeadLines[i])) {
                    this.headLines.add(newHeadLines[i]);
                    this.status.add(new HeadLineStatus(1, newHeadLines[i]));
                }
                ++i;
            }
            if (!this.holdNotifications) {
                this.fireHeadLineStatusEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHeadLines(IHeadLine[] oldHeadLines) {
        List<HeadLineStatus> list = this.status;
        synchronized (list) {
            int i = 0;
            while (i < oldHeadLines.length) {
                if (this.headLines.contains(oldHeadLines[i])) {
                    this.headLines.remove(oldHeadLines[i]);
                    this.status.add(new HeadLineStatus(2, oldHeadLines[i]));
                }
                ++i;
            }
            if (!this.holdNotifications) {
                this.fireHeadLineStatusEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHeadLines(IHeadLine[] updatedHeadLines) {
        List<HeadLineStatus> list = this.status;
        synchronized (list) {
            int i = 0;
            while (i < updatedHeadLines.length) {
                if (this.headLines.contains(updatedHeadLines[i])) {
                    this.status.add(new HeadLineStatus(0, updatedHeadLines[i]));
                }
                ++i;
            }
            if (!this.holdNotifications) {
                this.fireHeadLineStatusEvent();
            }
        }
    }

    protected void updateSecurityMap() {
        this.securityMap.clear();
        for (IHeadLine headLine : this.headLines) {
            ISecurity[] iSecurityArray = headLine.getMembers();
            int n = iSecurityArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISecurity security = iSecurityArray[n2];
                List<IHeadLine> list = this.securityMap.get(security);
                if (list == null) {
                    list = new ArrayList<IHeadLine>();
                    this.securityMap.put(security, list);
                }
                if (!list.contains(headLine)) {
                    list.add(headLine);
                }
                ++n2;
            }
        }
    }

    protected void fireHeadLineStatusEvent() {
        NewsEvent event = new NewsEvent(this, this.status.toArray(new HeadLineStatus[this.status.size()]));
        this.status.clear();
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            Status status;
            try {
                ((INewsServiceListener)l[i]).newsServiceUpdate(event);
            }
            catch (Exception e) {
                status = new Status(4, "org.eclipsetrader.news", 0, "Error notifying event to listener", (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            catch (LinkageError e) {
                status = new Status(4, "org.eclipsetrader.news", 0, "Error notifying event to listener", (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            ++i;
        }
    }

    @Override
    public IStatus runInService(INewsServiceRunnable runnable, IProgressMonitor monitor) {
        return this.runInService(runnable, this, monitor);
    }

    @Override
    public IStatus runInService(INewsServiceRunnable runnable, ISchedulingRule rule, IProgressMonitor monitor) {
        IStatus status;
        this.jobManager.beginRule(rule, monitor);
        try {
            try {
                this.lock.acquire();
                this.holdNotifications = true;
                try {
                    status = runnable.run(monitor);
                }
                catch (Exception e) {
                    status = new Status(4, "org.eclipsetrader.news", 0, "Error running service task", (Throwable)e);
                    Activator.getDefault().getLog().log(status);
                }
                catch (LinkageError e) {
                    status = new Status(4, "org.eclipsetrader.news", 0, "Error running service task", (Throwable)e);
                    Activator.getDefault().getLog().log(status);
                }
                this.updateSecurityMap();
                this.fireHeadLineStatusEvent();
            }
            catch (Exception e) {
                status = new Status(4, "org.eclipsetrader.news", 0, "Error running service task", (Throwable)e);
                Activator.getDefault().getLog().log(status);
                this.holdNotifications = false;
                this.lock.release();
                this.jobManager.endRule(rule);
            }
        }
        finally {
            this.holdNotifications = false;
            this.lock.release();
            this.jobManager.endRule(rule);
        }
        return status;
    }

    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            MultiRule multi = (MultiRule)rule;
            ISchedulingRule[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this == rule;
    }

    protected IConfigurationElement[] getProvidersConfigurationElements() {
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipsetrader.news.providers");
        if (extensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (e.getName().equals("provider")) {
                    elements.add(e);
                }
                ++n2;
            }
        }
        return elements.toArray(new IConfigurationElement[elements.size()]);
    }

    @Override
    public INewsProvider[] getProviders() {
        return this.providers.toArray(new INewsProvider[this.providers.size()]);
    }

    protected Date getLimitDate() {
        Calendar limit = Calendar.getInstance();
        limit.set(11, 0);
        limit.set(12, 0);
        limit.set(13, 0);
        limit.set(14, 0);
        limit.add(5, -Activator.getDefault().getPreferenceStore().getInt("DATE_RANGE"));
        return limit.getTime();
    }
}

