/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.news.internal.connectors;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.HashMapFeedInfoCache;
import com.sun.syndication.fetcher.impl.HttpClientFeedFetcher;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.news.core.IHeadLine;
import org.eclipsetrader.news.core.INewsProvider;
import org.eclipsetrader.news.core.INewsService;
import org.eclipsetrader.news.core.INewsServiceRunnable;
import org.eclipsetrader.news.internal.Activator;
import org.eclipsetrader.news.internal.connectors.FeedSource;
import org.eclipsetrader.news.internal.repository.HeadLine;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class RSSNewsProvider
implements INewsProvider,
IExecutableExtension {
    public static final String HEADLINES_FILE = "rss.xml";
    private String id;
    private String name;
    private FeedFetcherCache feedInfoCache = HashMapFeedInfoCache.getInstance();
    private HttpClientFeedFetcher fetcher = new HttpClientFeedFetcher(this.feedInfoCache);
    private INewsService newsService;
    private boolean started;
    private static List<HeadLine> oldItems = new ArrayList<HeadLine>();
    private JobChangeAdapter jobChangeListener = new JobChangeAdapter(){

        public void done(IJobChangeEvent event) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            int interval = store.getInt("UPDATE_INTERVAL");
            RSSNewsProvider.this.job.schedule((long)(interval * 60 * 1000));
        }
    };
    private Job job = new Job("RSS Subscriptions"){

        protected IStatus run(IProgressMonitor monitor) {
            return RSSNewsProvider.this.jobRunner(monitor);
        }
    };

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IHeadLine[] getHeadLines() {
        return new IHeadLine[0];
    }

    @Override
    public void start() {
        if (!this.started) {
            this.job.schedule(5000L);
            this.job.addJobChangeListener((IJobChangeListener)this.jobChangeListener);
            this.started = true;
        }
    }

    @Override
    public void stop() {
        if (this.started) {
            this.job.removeJobChangeListener((IJobChangeListener)this.jobChangeListener);
            this.job.cancel();
            this.started = false;
        }
    }

    @Override
    public void refresh() {
        this.job.removeJobChangeListener((IJobChangeListener)this.jobChangeListener);
        this.job.cancel();
        if (this.started) {
            this.job.addJobChangeListener((IJobChangeListener)this.jobChangeListener);
        }
        this.job.schedule(0L);
    }

    protected IStatus jobRunner(IProgressMonitor monitor) {
        final ArrayList<HeadLine> list = new ArrayList<HeadLine>();
        FeedSource[] sources = this.getActiveSubscriptions();
        monitor.beginTask("Updating RSS Subscriptions", sources.length);
        try {
            int i = 0;
            while (i < sources.length) {
                block11: {
                    try {
                        try {
                            HeadLine[] headLines;
                            HeadLine[] headLineArray = headLines = this.update(new URL(sources[i].getUrl()), sources[i].getName());
                            int n = headLines.length;
                            int n2 = 0;
                            while (n2 < n) {
                                HeadLine headLine = headLineArray[n2];
                                if (!oldItems.contains(headLine)) {
                                    headLine.setRecent(true);
                                    oldItems.add(headLine);
                                    list.add(headLine);
                                }
                                ++n2;
                            }
                        }
                        catch (Exception exception) {
                            Status status = new Status(2, "org.eclipsetrader.news", 0, "Error updating headlines from " + sources[i].getUrl(), null);
                            Activator.getDefault().getLog().log((IStatus)status);
                            monitor.worked(1);
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        monitor.worked(1);
                        throw throwable;
                    }
                    monitor.worked(1);
                }
                ++i;
            }
            final INewsService service = this.getNewsService();
            service.runInService(new INewsServiceRunnable(){

                @Override
                public IStatus run(IProgressMonitor monitor) throws Exception {
                    service.addHeadLines(list.toArray(new IHeadLine[list.size()]));
                    return Status.OK_STATUS;
                }
            }, null);
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    protected void resetRecentFlag() {
        final ArrayList<HeadLine> updated = new ArrayList<HeadLine>();
        for (HeadLine headLine : oldItems) {
            if (!headLine.isRecent()) continue;
            headLine.setRecent(false);
            updated.add(headLine);
        }
        final INewsService service = this.getNewsService();
        service.runInService(new INewsServiceRunnable(){

            @Override
            public IStatus run(IProgressMonitor monitor) throws Exception {
                service.updateHeadLines(updated.toArray(new IHeadLine[updated.size()]));
                return Status.OK_STATUS;
            }
        }, null);
    }

    protected FeedSource[] getActiveSubscriptions() {
        ArrayList<FeedSource> list = new ArrayList<FeedSource>();
        try {
            File file = Activator.getDefault().getStateLocation().append(HEADLINES_FILE).toFile();
            if (file.exists()) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FeedSource[].class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                unmarshaller.setEventHandler(new ValidationEventHandler(){

                    public boolean handleEvent(ValidationEvent event) {
                        Status status = new Status(2, "org.eclipsetrader.news", 0, "Error validating XML: " + event.getMessage(), null);
                        Activator.getDefault().getLog().log((IStatus)status);
                        return true;
                    }
                });
                JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(file), FeedSource[].class);
                FeedSource[] feedSourceArray = (FeedSource[])element.getValue();
                int n = feedSourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FeedSource source = feedSourceArray[n2];
                    if (source.isEnabled()) {
                        list.add(source);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            Status status = new Status(2, "org.eclipsetrader.news", 0, "Error reading RSS subscriptions", null);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return list.toArray(new FeedSource[list.size()]);
    }

    private HeadLine[] update(URL feedUrl, String source) {
        HashMap<String, SyndEntry> titles = new HashMap<String, SyndEntry>();
        HashMap entries = new HashMap();
        HashSet<HeadLine> headLines = new HashSet<HeadLine>();
        try {
            HashSet set;
            BundleContext context;
            ServiceReference reference;
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            if (Activator.getDefault() != null && (reference = (context = Activator.getDefault().getBundle().getBundleContext()).getServiceReference(IProxyService.class.getName())) != null) {
                IProxyService proxy = (IProxyService)context.getService(reference);
                IProxyData data = proxy.getProxyDataForHost(feedUrl.getHost(), "HTTP");
                if (data != null) {
                    if (data.getHost() != null) {
                        client.getHostConfiguration().setProxy(data.getHost(), data.getPort());
                    }
                    if (data.isRequiresAuthentication()) {
                        client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(data.getUserId(), data.getPassword()));
                    }
                }
                context.ungetService(reference);
            }
            SyndFeed feed = this.fetcher.retrieveFeed(feedUrl, client);
            for (SyndEntry entry : feed.getEntries()) {
                if (titles.containsKey(entry.getTitle())) {
                    entry = (SyndEntry)titles.get(entry.getTitle());
                } else {
                    titles.put(entry.getTitle(), entry);
                }
                set = (Set)entries.get(entry);
                if (set != null) continue;
                set = new HashSet();
                entries.put(entry, set);
            }
            for (SyndEntry entry : entries.keySet()) {
                int s;
                String title;
                set = (HashSet)entries.get(entry);
                String url = entry.getLink();
                if (url.indexOf(42) != -1) {
                    url = url.substring(url.indexOf(42) + 1);
                }
                if ((title = entry.getTitle()).endsWith(")") && (s = title.lastIndexOf(40)) != -1) {
                    source = title.substring(s + 1, title.length() - 1);
                    if (source.startsWith("at ")) {
                        source = source.substring(3);
                    }
                    title = title.substring(0, s - 1).trim();
                }
                HeadLine headLine = new HeadLine(entry.getPublishedDate(), source, title, set.toArray(new ISecurity[set.size()]), url);
                headLines.add(headLine);
            }
        }
        catch (Exception e) {
            Status status = new Status(2, "org.eclipsetrader.news", 0, "Error reading RSS subscription " + feedUrl.toString(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return headLines.toArray(new HeadLine[headLines.size()]);
    }

    protected INewsService getNewsService() {
        BundleContext context;
        ServiceReference serviceReference;
        if (this.newsService == null && (serviceReference = (context = Activator.getDefault().getBundle().getBundleContext()).getServiceReference(INewsService.class.getName())) != null) {
            this.newsService = (INewsService)context.getService(serviceReference);
            context.ungetService(serviceReference);
        }
        return this.newsService;
    }
}

