/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.news.internal.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipsetrader.news.internal.connectors.FeedSource;
import org.eclipsetrader.news.internal.preferences.Messages;

public class RSSFeedDialog
extends Dialog {
    private Text name;
    private Text url;
    private FeedSource feedSource;

    public RSSFeedDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RSSFeedDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = new Composite((Composite)super.createDialogArea(parent), 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setText(Messages.RSSFeedDialog_Source);
        label.setLayoutData((Object)new GridData(75, -1));
        this.name = new Text(content, 2048);
        this.name.setLayoutData((Object)new GridData(140, -1));
        this.name.setText(this.feedSource != null ? this.feedSource.getName() : "");
        label = new Label(content, 0);
        label.setText(Messages.RSSFeedDialog_URL);
        label.setLayoutData((Object)new GridData(75, -1));
        this.url = new Text(content, 2048);
        this.url.setLayoutData((Object)new GridData(280, -1));
        this.url.setText(this.feedSource != null ? this.feedSource.getUrl() : "");
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RSSFeedDialog.this.getButton(0).setEnabled(RSSFeedDialog.this.url.getText().length() != 0);
            }
        });
        return content;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.url.getText().length() != 0);
        return control;
    }

    protected void okPressed() {
        this.feedSource = new FeedSource(this.name.getText(), this.url.getText());
        super.okPressed();
    }

    public FeedSource getFeedSource() {
        return this.feedSource;
    }

    public void setFeedSource(FeedSource feedSource) {
        this.feedSource = feedSource;
    }
}

