/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.news.internal.repository;

import java.net.URI;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.instruments.IUserProperties;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.news.internal.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SecurityAdapter
extends XmlAdapter<String, ISecurity> {
    private static IRepositoryService repositoryService;

    public static void setRepositoryService(IRepositoryService service) {
        repositoryService = service;
    }

    public String marshal(ISecurity v) throws Exception {
        if (v == null) {
            return null;
        }
        IStoreObject storeObject = (IStoreObject)v.getAdapter(IStoreObject.class);
        return storeObject.getStore().toURI().toString();
    }

    public ISecurity unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        URI uri = new URI(v);
        ISecurity security = this.getSecurity(uri);
        if (security == null) {
            Status status = new Status(2, "org.eclipsetrader.news", 0, "Failed to load security " + uri.toString(), null);
            Activator.log((IStatus)status);
            return new FailsafeSecurity(uri);
        }
        return security;
    }

    protected ISecurity getSecurity(URI uri) {
        if (repositoryService == null && Activator.getDefault() != null) {
            try {
                BundleContext context = Activator.getDefault().getBundle().getBundleContext();
                ServiceReference serviceReference = context.getServiceReference(IRepositoryService.class.getName());
                repositoryService = (IRepositoryService)context.getService(serviceReference);
                context.ungetService(serviceReference);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipsetrader.news", 0, "Error reading repository service", (Throwable)e);
                Activator.log((IStatus)status);
            }
        }
        return repositoryService != null ? repositoryService.getSecurityFromURI(uri) : null;
    }

    public class FailsafeSecurity
    implements ISecurity,
    IStoreObject,
    IStore {
        private URI uri;

        public FailsafeSecurity(URI uri) {
            this.uri = uri;
        }

        public IFeedIdentifier getIdentifier() {
            return null;
        }

        public String getName() {
            return this.uri.toString();
        }

        public IUserProperties getProperties() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isAssignableFrom(this.getClass())) {
                return this;
            }
            return null;
        }

        public IStore getStore() {
            return this;
        }

        public IStoreProperties getStoreProperties() {
            return null;
        }

        public void setStore(IStore store) {
        }

        public void setStoreProperties(IStoreProperties storeProperties) {
        }

        public void delete(IProgressMonitor monitor) throws CoreException {
        }

        public IStoreProperties fetchProperties(IProgressMonitor monitor) {
            return null;
        }

        public IStore[] fetchChilds(IProgressMonitor monitor) {
            return null;
        }

        public IStore createChild() {
            return null;
        }

        public IRepository getRepository() {
            return null;
        }

        public void putProperties(IStoreProperties properties, IProgressMonitor monitor) {
        }

        public URI toURI() {
            return this.uri;
        }
    }
}

