/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.news.internal.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.news.core.HeadLineStatus;
import org.eclipsetrader.news.core.IHeadLine;
import org.eclipsetrader.news.core.INewsProvider;
import org.eclipsetrader.news.core.INewsService;
import org.eclipsetrader.news.core.INewsServiceListener;
import org.eclipsetrader.news.core.NewsEvent;
import org.eclipsetrader.news.internal.Activator;
import org.eclipsetrader.news.internal.ui.HeadLineLabelProvider;
import org.eclipsetrader.news.internal.ui.Messages;
import org.eclipsetrader.news.internal.ui.NewsViewer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HeadLineViewer
extends ViewPart {
    public static final String VIEW_ID = "org.eclipsetrader.ui.views.headlines";
    private static final String K_VIEWS = "Views";
    private static final String K_URI = "uri";
    private static final String K_COLUMNS = "columns";
    private Action refreshAction;
    private Action showPreviousAction;
    private Action showNextAction;
    private Action openAction;
    private Action openNewWindowAction;
    private Action markAsReadAction;
    private Action markAllAsReadAction;
    private TableViewer viewer;
    private IDialogSettings dialogSettings;
    private INewsService service;
    private List<IHeadLine> input;
    private ISecurity security;
    private ControlAdapter controlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            TableColumn tableColumn = (TableColumn)e.widget;
            int index = HeadLineViewer.this.viewer.getTable().indexOf(tableColumn);
            if (HeadLineViewer.this.dialogSettings != null) {
                IDialogSettings columnsSection = HeadLineViewer.this.dialogSettings.getSection(HeadLineViewer.K_COLUMNS);
                if (columnsSection == null) {
                    columnsSection = HeadLineViewer.this.dialogSettings.addNewSection(HeadLineViewer.K_COLUMNS);
                }
                columnsSection.put(String.valueOf(index), tableColumn.getWidth());
            }
        }
    };
    private INewsServiceListener newsListener = new INewsServiceListener(){

        @Override
        public void newsServiceUpdate(NewsEvent event) {
            block8: {
                HeadLineStatus[] headLineStatusArray = event.getStatus();
                int n = headLineStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HeadLineStatus status = headLineStatusArray[n2];
                    if (HeadLineViewer.this.security == null || status.getHeadLine().contains(HeadLineViewer.this.security)) {
                        if (status.getKind() == 1) {
                            HeadLineViewer.this.input.add(status.getHeadLine());
                        } else if (status.getKind() == 2) {
                            HeadLineViewer.this.input.remove(status.getHeadLine());
                        }
                    }
                    ++n2;
                }
                if (!HeadLineViewer.this.viewer.getControl().isDisposed()) {
                    try {
                        HeadLineViewer.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!HeadLineViewer.this.viewer.getControl().isDisposed()) {
                                    HeadLineViewer.this.viewer.refresh();
                                    HeadLineViewer.this.updateTitleImage();
                                }
                            }
                        });
                    }
                    catch (SWTException e) {
                        if (e.code == 24) break block8;
                        throw e;
                    }
                }
            }
        }
    };
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            HeadLineViewer.this.viewer.setSelection(selection, true);
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        IDialogSettings bundleDialogSettings = Activator.getDefault().getDialogSettings();
        if (site.getSecondaryId() != null) {
            try {
                this.dialogSettings = bundleDialogSettings.getSection(K_VIEWS).getSection(site.getSecondaryId());
                URI uri = new URI(this.dialogSettings.get(K_URI));
                IRepositoryService repositoryService = Activator.getDefault().getRepositoryService();
                this.security = repositoryService.getSecurityFromURI(uri);
                if (this.security != null) {
                    this.setPartName(NLS.bind((String)"{0} - {1}", (Object[])new Object[]{this.security.getName(), this.getPartName()}));
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipsetrader.news", "Error loading view " + site.getSecondaryId(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        if (this.dialogSettings == null) {
            this.dialogSettings = bundleDialogSettings.getSection(((Object)((Object)this)).getClass().getName());
            if (this.dialogSettings == null) {
                this.dialogSettings = bundleDialogSettings.addNewSection(((Object)((Object)this)).getClass().getName());
            }
        }
        this.refreshAction = new Action(Messages.HeadLineViewer_Refresh){

            public void run() {
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                INewsProvider[] providers = HeadLineViewer.this.service.getProviders();
                int i = 0;
                while (i < providers.length) {
                    if (store.getBoolean(providers[i].getId())) {
                        providers[i].refresh();
                    }
                    ++i;
                }
            }
        };
        this.refreshAction.setImageDescriptor(Activator.getImageDescriptor("icons/elcl16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/dlcl16/refresh.gif"));
        this.showPreviousAction = new Action(Messages.HeadLineViewer_Previous){

            public void run() {
                IHeadLine headLine = HeadLineViewer.this.getPreviousHeadLine();
                if (headLine != null) {
                    HeadLineViewer.this.viewer.setSelection((ISelection)new StructuredSelection((Object)headLine), true);
                    HeadLineViewer.this.doOpenHeadLine(headLine, false);
                }
            }
        };
        this.showPreviousAction.setImageDescriptor(Activator.getImageDescriptor("icons/elcl16/prev_nav.gif"));
        this.showPreviousAction.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/dlcl16/prev_nav.gif"));
        this.showNextAction = new Action(Messages.HeadLineViewer_Next){

            public void run() {
                IHeadLine headLine = HeadLineViewer.this.getNextHeadLine();
                if (headLine != null) {
                    HeadLineViewer.this.viewer.setSelection((ISelection)new StructuredSelection((Object)headLine), true);
                    HeadLineViewer.this.doOpenHeadLine(headLine, false);
                }
            }
        };
        this.showNextAction.setImageDescriptor(Activator.getImageDescriptor("icons/elcl16/next_nav.gif"));
        this.showNextAction.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/dlcl16/next_nav.gif"));
        this.openAction = new Action(Messages.HeadLineViewer_Open){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)HeadLineViewer.this.viewer.getSelection();
                if (!selection.isEmpty()) {
                    IHeadLine headLine = (IHeadLine)selection.getFirstElement();
                    HeadLineViewer.this.doOpenHeadLine(headLine, false);
                }
            }
        };
        this.openNewWindowAction = new Action(Messages.HeadLineViewer_OpenInNewBrowser){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)HeadLineViewer.this.viewer.getSelection();
                if (!selection.isEmpty()) {
                    IHeadLine headLine = (IHeadLine)selection.getFirstElement();
                    HeadLineViewer.this.doOpenHeadLine(headLine, true);
                }
            }
        };
        this.markAsReadAction = new Action(Messages.HeadLineViewer_MarkAsRead){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)HeadLineViewer.this.viewer.getSelection();
                List list = selection.toList();
                IHeadLine[] headLines = list.toArray(new IHeadLine[list.size()]);
                int i = 0;
                while (i < headLines.length) {
                    headLines[i].setReaded(true);
                    ++i;
                }
                HeadLineViewer.this.service.updateHeadLines(headLines);
            }
        };
        this.markAllAsReadAction = new Action(Messages.HeadLineViewer_MarkAllAsRead){

            public void run() {
                IHeadLine[] headLines = HeadLineViewer.this.input.toArray(new IHeadLine[HeadLineViewer.this.input.size()]);
                int i = 0;
                while (i < headLines.length) {
                    headLines[i].setReaded(true);
                    ++i;
                }
                HeadLineViewer.this.service.updateHeadLines(headLines);
            }
        };
        IToolBarManager toolBarManager = site.getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("begin"));
        toolBarManager.add((IAction)this.showPreviousAction);
        toolBarManager.add((IAction)this.showNextAction);
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add((IContributionItem)new Separator("end"));
    }

    public void createPartControl(Composite parent) {
        this.createViewer(parent);
        this.input = new ArrayList<IHeadLine>(Arrays.asList(this.getHeadLines()));
        this.viewer.setInput(this.input);
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("group.new"));
                menuManager.add((IContributionItem)new GroupMarker("group.goto"));
                menuManager.add((IContributionItem)new Separator("group.open"));
                menuManager.add((IContributionItem)new GroupMarker("group.openWith"));
                menuManager.add((IContributionItem)new Separator("group.show"));
                menuManager.add((IContributionItem)new Separator("group.edit"));
                menuManager.add((IContributionItem)new GroupMarker("group.reorganize"));
                menuManager.add((IContributionItem)new GroupMarker("group.port"));
                menuManager.add((IContributionItem)new Separator("group.generate"));
                menuManager.add((IContributionItem)new Separator("group.search"));
                menuManager.add((IContributionItem)new Separator("group.build"));
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IContributionItem)new Separator("group.properties"));
                menuManager.appendToGroup("group.open", (IAction)HeadLineViewer.this.openAction);
                menuManager.appendToGroup("group.open", (IAction)HeadLineViewer.this.openNewWindowAction);
                menuManager.appendToGroup("group.edit", (IAction)HeadLineViewer.this.markAsReadAction);
                menuManager.appendToGroup("group.edit", (IAction)HeadLineViewer.this.markAllAsReadAction);
            }
        });
        this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
        if (this.getSite() != null) {
            this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
            this.getSite().getPage().addSelectionListener(this.selectionListener);
            this.viewer.setSelection(this.getSite().getPage().getSelection(), true);
        }
    }

    protected void updateTitleImage() {
        if (this.hasUnreadedHeadlines()) {
            this.setTitleImage(Activator.getDefault().getImageRegistry().get("new_headlines_icon"));
        } else {
            this.setTitleImage(Activator.getDefault().getImageRegistry().get("normal_icon"));
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.service != null) {
            this.service.removeNewsServiceListener(this.newsListener);
        }
        this.getSite().getPage().removeSelectionListener(this.selectionListener);
        super.dispose();
    }

    protected void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 65538);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(false);
        IDialogSettings columnsSection = this.dialogSettings != null ? this.dialogSettings.getSection(K_COLUMNS) : null;
        TableColumn tableColumn = new TableColumn(this.viewer.getTable(), 16384);
        tableColumn.setText(Messages.HeadLineViewer_Date);
        tableColumn.setWidth(columnsSection != null && columnsSection.get(String.valueOf(this.viewer.getTable().indexOf(tableColumn))) != null ? columnsSection.getInt(String.valueOf(this.viewer.getTable().indexOf(tableColumn))) : 160);
        tableColumn.addControlListener((ControlListener)this.controlListener);
        tableColumn = new TableColumn(this.viewer.getTable(), 16384);
        tableColumn.setText(Messages.HeadLineViewer_Title);
        tableColumn.setWidth(columnsSection != null && columnsSection.get(String.valueOf(this.viewer.getTable().indexOf(tableColumn))) != null ? columnsSection.getInt(String.valueOf(this.viewer.getTable().indexOf(tableColumn))) : 300);
        tableColumn.addControlListener((ControlListener)this.controlListener);
        tableColumn = new TableColumn(this.viewer.getTable(), 16384);
        tableColumn.setText(Messages.HeadLineViewer_Security);
        tableColumn.setWidth(columnsSection != null && columnsSection.get(String.valueOf(this.viewer.getTable().indexOf(tableColumn))) != null ? columnsSection.getInt(String.valueOf(this.viewer.getTable().indexOf(tableColumn))) : 250);
        tableColumn.addControlListener((ControlListener)this.controlListener);
        tableColumn = new TableColumn(this.viewer.getTable(), 16384);
        tableColumn.setText(Messages.HeadLineViewer_Source);
        tableColumn.setWidth(columnsSection != null && columnsSection.get(String.valueOf(this.viewer.getTable().indexOf(tableColumn))) != null ? columnsSection.getInt(String.valueOf(this.viewer.getTable().indexOf(tableColumn))) : 200);
        tableColumn.addControlListener((ControlListener)this.controlListener);
        this.viewer.setLabelProvider((IBaseLabelProvider)new HeadLineLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                return ((IHeadLine)e2).getDate().compareTo(((IHeadLine)e1).getDate());
            }

            public int category(Object element) {
                IHeadLine headLine = (IHeadLine)element;
                return headLine.isRecent() ? 0 : 1;
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (!event.getSelection().isEmpty()) {
                    IHeadLine headLine = (IHeadLine)((IStructuredSelection)event.getSelection()).getFirstElement();
                    HeadLineViewer.this.doOpenHeadLine(headLine, false);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HeadLineViewer.this.openAction.setEnabled(!event.getSelection().isEmpty());
                HeadLineViewer.this.markAsReadAction.setEnabled(!event.getSelection().isEmpty());
                HeadLineViewer.this.markAllAsReadAction.setEnabled(HeadLineViewer.this.input.size() != 0);
            }
        });
    }

    protected void doOpenHeadLine(IHeadLine headLine, boolean newWindow) {
        IWorkbenchPage page = this.getSite().getPage();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            NewsViewer viewer;
            if (refs[i].getId().equals("org.eclipsetrader.news.browser") && headLine.equals((viewer = (NewsViewer)refs[i].getPart(true)).getHeadLine())) {
                if (!page.isPartVisible((IWorkbenchPart)viewer)) {
                    page.bringToTop((IWorkbenchPart)viewer);
                }
                return;
            }
            ++i;
        }
        try {
            IViewPart viewPart = newWindow ? page.showView("org.eclipsetrader.news.browser", UUID.randomUUID().toString(), 1) : page.showView("org.eclipsetrader.news.browser", null, 2);
            ((NewsViewer)viewPart).setHeadLine(headLine);
            headLine.setReaded(true);
            if (this.service != null) {
                this.service.updateHeadLines(new IHeadLine[]{headLine});
            }
        }
        catch (PartInitException partInitException) {
            Status status = new Status(2, "org.eclipsetrader.news", 0, "Unexpected error activating browser", null);
            Activator.log((IStatus)status);
        }
    }

    protected int indexOf(IHeadLine headLine) {
        TableItem[] tableItem = this.viewer.getTable().getItems();
        int i = 0;
        while (i < tableItem.length) {
            if (headLine.equals(tableItem[i].getData())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected IHeadLine getNextHeadLine() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            int index = this.indexOf((IHeadLine)selection.getFirstElement());
            if (index == -1) {
                if (this.viewer.getTable().getItemCount() == 0) {
                    return null;
                }
                return (IHeadLine)this.viewer.getTable().getItem(0).getData();
            }
            if (++index < this.viewer.getTable().getItemCount()) {
                return (IHeadLine)this.viewer.getTable().getItem(index).getData();
            }
        }
        if (this.viewer.getTable().getItemCount() == 0) {
            return null;
        }
        return (IHeadLine)this.viewer.getTable().getItem(0).getData();
    }

    protected IHeadLine getPreviousHeadLine() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            int index = this.indexOf((IHeadLine)selection.getFirstElement());
            if (index == -1) {
                if (this.viewer.getTable().getItemCount() == 0) {
                    return null;
                }
                return (IHeadLine)this.viewer.getTable().getItem(this.viewer.getTable().getItemCount() - 1).getData();
            }
            if (--index >= 0) {
                return (IHeadLine)this.viewer.getTable().getItem(index).getData();
            }
        }
        if (this.viewer.getTable().getItemCount() == 0) {
            return null;
        }
        return (IHeadLine)this.viewer.getTable().getItem(this.viewer.getTable().getItemCount() - 1).getData();
    }

    TableViewer getViewer() {
        return this.viewer;
    }

    protected IHeadLine[] getHeadLines() {
        IHeadLine[] result = new IHeadLine[]{};
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(INewsService.class.getName());
        if (serviceReference != null) {
            this.service = (INewsService)context.getService(serviceReference);
            if (this.service != null) {
                result = this.security != null ? this.service.getHeadLinesFor(this.security) : this.service.getHeadLines();
                this.service.addNewsServiceListener(this.newsListener);
            }
            context.ungetService(serviceReference);
        }
        return result;
    }

    protected boolean hasUnreadedHeadlines() {
        for (IHeadLine headLine : this.input) {
            if (headLine.isReaded()) continue;
            return true;
        }
        return false;
    }
}

