/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.news.internal.ui;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.news.core.INewsService;
import org.eclipsetrader.news.core.INewsServiceListener;
import org.eclipsetrader.news.core.NewsEvent;
import org.eclipsetrader.news.internal.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class NewsDecorator
implements ILightweightLabelDecorator {
    private ImageDescriptor unreadedDescriptor;
    private ImageDescriptor readedDescriptor;
    private boolean enabled;
    private INewsService newsService;
    private ListenerList listeners = new ListenerList(1);
    private INewsServiceListener newsListener = new INewsServiceListener(){

        @Override
        public void newsServiceUpdate(NewsEvent event) {
            NewsDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)NewsDecorator.this));
        }
    };
    IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("ENABLE_DECORATORS")) {
                NewsDecorator.this.enabled = (Boolean)event.getNewValue();
                NewsDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)NewsDecorator.this));
            }
        }
    };

    public NewsDecorator() {
        if (Activator.getDefault() != null) {
            this.unreadedDescriptor = Activator.getDefault().getImageRegistry().getDescriptor("unreaded_ovr");
            this.readedDescriptor = Activator.getDefault().getImageRegistry().getDescriptor("readed_ovr");
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            store.addPropertyChangeListener(this.propertyChangeListener);
            this.enabled = store.getBoolean("ENABLE_DECORATORS");
        }
        this.newsService = this.getNewsService();
        this.newsService.addNewsServiceListener(this.newsListener);
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void dispose() {
        if (Activator.getDefault() != null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            store.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.newsService.removeNewsServiceListener(this.newsListener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void decorate(Object element, IDecoration decoration) {
        IViewItem viewItem;
        ISecurity security;
        if (this.enabled && element instanceof IViewItem && (security = (ISecurity)(viewItem = (IViewItem)element).getAdapter(ISecurity.class)) != null) {
            if (this.newsService.hasUnreadedHeadLinesFor(security)) {
                decoration.addOverlay(this.unreadedDescriptor);
            } else if (this.newsService.hasHeadLinesFor(security)) {
                decoration.addOverlay(this.readedDescriptor);
            }
        }
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Object[] listeners = NewsDecorator.this.listeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    final ILabelProviderListener l = (ILabelProviderListener)listeners[i];
                    SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                        public void run() {
                            l.labelProviderChanged(event);
                        }
                    });
                    ++i;
                }
            }
        });
    }

    protected INewsService getNewsService() {
        BundleContext context;
        ServiceReference serviceReference;
        if (this.newsService == null && (serviceReference = (context = Activator.getDefault().getBundle().getBundleContext()).getServiceReference(INewsService.class.getName())) != null) {
            this.newsService = (INewsService)context.getService(serviceReference);
            context.ungetService(serviceReference);
        }
        return this.newsService;
    }
}

