/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper;

import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.Cash;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IOrderSide;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.core.trading.IPositionListener;
import org.eclipsetrader.core.trading.ITransaction;
import org.eclipsetrader.core.trading.PositionEvent;
import org.eclipsetrader.internal.brokers.paper.Activator;
import org.eclipsetrader.internal.brokers.paper.IExpenseScheme;
import org.eclipsetrader.internal.brokers.paper.OrderMonitor;
import org.eclipsetrader.internal.brokers.paper.Position;
import org.eclipsetrader.internal.brokers.paper.transactions.ExpenseTransaction;
import org.eclipsetrader.internal.brokers.paper.transactions.StockTransaction;
import org.eclipsetrader.internal.brokers.paper.transactions.TradeTransaction;
import org.eclipsetrader.internal.brokers.paper.types.CurrencyAdapter;
import org.eclipsetrader.internal.brokers.paper.types.ExpenseSchemeAdapter;

@XmlRootElement(name="account")
public class Account
implements IAccount {
    @XmlAttribute(name="id")
    private String id;
    @XmlElement(name="description")
    private String description;
    @XmlAttribute(name="currency")
    @XmlJavaTypeAdapter(value=CurrencyAdapter.class)
    private Currency currency;
    @XmlElement(name="balance")
    private Double balance = 0.0;
    @XmlElementWrapper(name="transactions")
    @XmlElementRefs(value={@XmlElementRef(type=ExpenseTransaction.class), @XmlElementRef(type=TradeTransaction.class), @XmlElementRef(type=StockTransaction.class)})
    private List<ITransaction> transactions = new ArrayList<ITransaction>();
    @XmlElementWrapper(name="portfolio")
    @XmlElementRef
    private List<Position> portfolio = new ArrayList<Position>();
    @XmlAttribute(name="expense-scheme")
    @XmlJavaTypeAdapter(value=ExpenseSchemeAdapter.class)
    private IExpenseScheme expenseScheme;
    private ListenerList listeners = new ListenerList();

    protected Account() {
    }

    public Account(String description) {
        this.id = UUID.randomUUID().toString();
        this.description = description;
        try {
            this.currency = Currency.getInstance(Locale.getDefault());
        }
        catch (Exception exception) {}
        this.balance = 0.0;
    }

    @XmlTransient
    public String getId() {
        return this.id;
    }

    @XmlTransient
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlTransient
    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    @XmlTransient
    public Cash getBalance() {
        return new Cash(this.balance, this.currency);
    }

    public void setBalance(Double balance) {
        this.balance = balance;
    }

    @XmlTransient
    public IExpenseScheme getExpenseScheme() {
        return this.expenseScheme;
    }

    public void setExpenseScheme(IExpenseScheme expenseScheme) {
        this.expenseScheme = expenseScheme;
    }

    @XmlTransient
    public ITransaction[] getTransactions() {
        return this.transactions.toArray(new ITransaction[this.transactions.size()]);
    }

    public void processCompletedOrder(OrderMonitor monitor) {
        Double expenses = null;
        if (this.expenseScheme != null) {
            if (monitor.getOrder().getSide() == IOrderSide.Buy) {
                expenses = this.expenseScheme.getBuyExpenses(monitor.getFilledQuantity(), monitor.getAveragePrice());
            } else if (monitor.getOrder().getSide() == IOrderSide.Sell) {
                expenses = this.expenseScheme.getSellExpenses(monitor.getFilledQuantity(), monitor.getAveragePrice());
            }
        }
        TradeTransaction transaction = new TradeTransaction(monitor.getOrder(), monitor.getTransactions(), expenses != null ? new ExpenseTransaction(new Cash(expenses, this.currency)) : null);
        this.transactions.add(transaction);
        this.balance = this.balance - transaction.getAmount().getAmount();
        Position position = null;
        for (Position p : this.portfolio) {
            if (p.getSecurity() != monitor.getOrder().getSecurity()) continue;
            position = p;
            break;
        }
        Long quantity = monitor.getOrder().getSide() == IOrderSide.Sell ? -monitor.getFilledQuantity().longValue() : monitor.getFilledQuantity();
        double averagePrice = transaction.getAmount().getAmount() / (double)monitor.getFilledQuantity().longValue();
        if (position == null) {
            position = new Position(monitor.getOrder().getSecurity(), quantity, averagePrice);
            this.portfolio.add(position);
            this.firePositionOpenedEvent(position);
        } else {
            position.add(quantity, averagePrice);
            if (position.getQuantity() == 0L) {
                this.portfolio.remove(position);
                this.firePositionClosedEvent(position);
            } else {
                this.firePositionChangedEvent(position);
            }
        }
    }

    protected void firePositionOpenedEvent(Position position) {
        PositionEvent event = new PositionEvent((IAccount)this, (IPosition)position);
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((IPositionListener)l[i]).positionOpened(event);
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.eclipsetrader.brokers.paper", "Error notifying listeners", t);
                Activator.log((IStatus)status);
            }
            ++i;
        }
    }

    protected void firePositionClosedEvent(Position position) {
        PositionEvent event = new PositionEvent((IAccount)this, (IPosition)position);
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((IPositionListener)l[i]).positionClosed(event);
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.eclipsetrader.brokers.paper", "Error notifying listeners", t);
                Activator.log((IStatus)status);
            }
            ++i;
        }
    }

    protected void firePositionChangedEvent(Position position) {
        PositionEvent event = new PositionEvent((IAccount)this, (IPosition)position);
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((IPositionListener)l[i]).positionChanged(event);
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.eclipsetrader.brokers.paper", "Error notifying listeners", t);
                Activator.log((IStatus)status);
            }
            ++i;
        }
    }

    @XmlTransient
    public IPosition[] getPositions() {
        return this.portfolio.toArray(new IPosition[this.portfolio.size()]);
    }

    public void addPositionListener(IPositionListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePositionListener(IPositionListener listener) {
        this.listeners.remove((Object)listener);
    }
}

