/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.internal.brokers.paper.Account;
import org.eclipsetrader.internal.brokers.paper.Activator;

public class AccountRepository {
    private static AccountRepository instance;
    private List<Account> accounts = new ArrayList<Account>();

    public AccountRepository() {
        instance = this;
    }

    public static AccountRepository getInstance() {
        return instance;
    }

    public void add(Account account) {
        this.accounts.add(account);
    }

    public void remove(Account account) {
        this.accounts.remove(account);
    }

    public int size() {
        return this.accounts.size();
    }

    public IAccount[] getAccounts() {
        return this.accounts.toArray(new Account[this.accounts.size()]);
    }

    void load(File file) throws JAXBException {
        if (!file.exists()) {
            return;
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Account[].class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                Status status = new Status(2, "org.eclipsetrader.brokers.paper", 0, "Error validating XML: " + event.getMessage(), null);
                Activator.log((IStatus)status);
                return true;
            }
        });
        JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(file), Account[].class);
        if (element != null) {
            this.accounts.addAll(Arrays.asList((Account[])element.getValue()));
        }
    }

    void save(File file) throws JAXBException, IOException {
        if (file.exists()) {
            file.delete();
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Account[].class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                Status status = new Status(2, "org.eclipsetrader.brokers.paper", 0, "Error validating XML: " + event.getMessage(), null);
                Activator.log((IStatus)status);
                return true;
            }
        });
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)System.getProperty("file.encoding"));
        Account[] elements = this.accounts.toArray(new Account[this.accounts.size()]);
        JAXBElement element = new JAXBElement(new QName("list"), Account[].class, (Object)elements);
        marshaller.marshal((Object)element, (Writer)new FileWriter(file));
    }
}

