/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.trading.BrokerException;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IOrderMonitor;
import org.eclipsetrader.core.trading.IOrderMonitorListener;
import org.eclipsetrader.core.trading.IOrderStatus;
import org.eclipsetrader.core.trading.ITransaction;
import org.eclipsetrader.core.trading.OrderMonitorEvent;
import org.eclipsetrader.internal.brokers.paper.Activator;
import org.eclipsetrader.internal.brokers.paper.PaperBroker;
import org.eclipsetrader.internal.brokers.paper.PaperBrokerFactory;
import org.eclipsetrader.internal.brokers.paper.transactions.OrderElement;
import org.eclipsetrader.internal.brokers.paper.types.DoubleValueAdapter;
import org.eclipsetrader.internal.brokers.paper.types.OrderStatusAdapter;

@XmlRootElement(name="monitor")
public class OrderMonitor
implements IOrderMonitor,
IAdaptable {
    @XmlAttribute(name="id")
    private String id;
    @XmlElement(name="order")
    private OrderElement order;
    @XmlAttribute(name="filled-qty")
    private Long filledQuantity;
    @XmlAttribute(name="avg-price")
    @XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
    private Double averagePrice;
    @XmlAttribute(name="status")
    @XmlJavaTypeAdapter(value=OrderStatusAdapter.class)
    private IOrderStatus status = IOrderStatus.New;
    @XmlAttribute(name="message")
    private String message;
    private PaperBroker broker;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ListenerList listeners = new ListenerList(1);
    private List<ITransaction> transactions = new ArrayList<ITransaction>();

    protected OrderMonitor() {
        try {
            this.broker = (PaperBroker)new PaperBrokerFactory().create();
        }
        catch (CoreException e) {
            Status status = new Status(2, "org.eclipsetrader.brokers.paper", 0, "Error initializing monitor", (Throwable)e);
            Activator.log((IStatus)status);
        }
    }

    public OrderMonitor(PaperBroker broker, IOrder order) {
        this.broker = broker;
        this.order = new OrderElement(order);
    }

    @XmlTransient
    public IBroker getBrokerConnector() {
        return this.broker;
    }

    @XmlTransient
    public String getId() {
        return this.id;
    }

    public void setId(String assignedId) {
        this.id = assignedId;
    }

    @XmlTransient
    public IOrder getOrder() {
        return this.order.getOrder();
    }

    public void submit() throws BrokerException {
    }

    public void cancel() throws BrokerException {
    }

    public boolean allowModify() {
        return false;
    }

    public void modify(IOrder order) throws BrokerException {
        throw new BrokerException("Modify not allowed");
    }

    public void addOrderMonitorListener(IOrderMonitorListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeOrderMonitorListener(IOrderMonitorListener listener) {
        this.listeners.remove((Object)listener);
    }

    @XmlTransient
    public IOrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(IOrderStatus status) {
        IOrderStatus oldValue = this.status;
        if (this.status != status) {
            this.status = status;
            this.propertyChangeSupport.firePropertyChange("status", oldValue, this.status);
        }
    }

    @XmlTransient
    public Long getFilledQuantity() {
        return this.filledQuantity;
    }

    public void setFilledQuantity(Long filledQuantity) {
        Long oldValue = this.filledQuantity;
        if (filledQuantity != null && !filledQuantity.equals(this.filledQuantity)) {
            this.filledQuantity = filledQuantity;
            this.propertyChangeSupport.firePropertyChange("filledQuantity", oldValue, this.filledQuantity);
        }
    }

    @XmlTransient
    public Double getAveragePrice() {
        return this.averagePrice;
    }

    public void setAveragePrice(Double averagePrice) {
        Double oldValue = this.averagePrice;
        if (averagePrice != null && !averagePrice.equals(this.averagePrice)) {
            this.averagePrice = averagePrice;
            this.propertyChangeSupport.firePropertyChange("averagePrice", oldValue, this.averagePrice);
        }
    }

    @XmlTransient
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.propertyChangeSupport.getClass())) {
            return this.propertyChangeSupport;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public void fireOrderCompletedEvent() {
        OrderMonitorEvent event = new OrderMonitorEvent((IOrderMonitor)this, this.order.getOrder());
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((IOrderMonitorListener)l[i]).orderCompleted(event);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    @XmlTransient
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public void addTransaction(ITransaction transaction) {
        this.transactions.add(transaction);
    }

    @XmlTransient
    public ITransaction[] getTransactions() {
        return this.transactions.toArray(new ITransaction[this.transactions.size()]);
    }

    public String toString() {
        return "OrderMonitor: id=" + this.getId() + ", status=" + this.getStatus() + ", filledQuantity=" + this.getFilledQuantity() + ", averagePrice=" + this.getAveragePrice() + " [" + this.order.toString() + "]";
    }
}

