/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.internal.brokers.paper.Activator;
import org.eclipsetrader.internal.brokers.paper.PaperBroker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PaperBrokerFactory
implements IExecutableExtension,
IExecutableExtensionFactory {
    private static PaperBroker instance;
    private IConfigurationElement config;
    private ServiceReference<IMarketService> marketServiceReference;
    private IMarketService marketService;
    private ServiceReference<IRepositoryService> repositoryServiceReference;
    private IRepositoryService repositoryService;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.config = config;
    }

    public Object create() throws CoreException {
        if (instance == null) {
            BundleContext context = Activator.getDefault().getBundle().getBundleContext();
            this.marketServiceReference = context.getServiceReference(IMarketService.class);
            if (this.marketServiceReference != null) {
                this.marketService = (IMarketService)context.getService(this.marketServiceReference);
            }
            this.repositoryServiceReference = context.getServiceReference(IRepositoryService.class);
            if (this.repositoryServiceReference != null) {
                this.repositoryService = (IRepositoryService)context.getService(this.repositoryServiceReference);
            }
            String id = this.config.getAttribute("id");
            String name = this.config.getAttribute("name");
            instance = new PaperBroker(id, name, this.marketService, this.repositoryService);
            try {
                instance.load(Activator.getDefault().getStateLocation().append("monitors.xml").toFile());
            }
            catch (Exception e) {
                Status status = new Status(2, "org.eclipsetrader.brokers.paper", 0, "Error loading monitors", (Throwable)e);
                Activator.log((IStatus)status);
            }
        }
        return instance;
    }

    public void dispose() {
        try {
            if (instance != null) {
                instance.save(Activator.getDefault().getStateLocation().append("monitors.xml").toFile());
                BundleContext context = Activator.getDefault().getBundle().getBundleContext();
                if (this.marketServiceReference != null) {
                    context.ungetService(this.marketServiceReference);
                }
                if (this.repositoryServiceReference != null) {
                    context.ungetService(this.repositoryServiceReference);
                }
            }
        }
        catch (Exception e) {
            Status status = new Status(2, "org.eclipsetrader.brokers.paper", 0, "Error saving monitors", (Throwable)e);
            Activator.log((IStatus)status);
        }
        instance = null;
    }
}

