/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper;

import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.internal.brokers.paper.types.DateTimeAdapter;
import org.eclipsetrader.internal.brokers.paper.types.SecurityAdapter;

@XmlRootElement(name="position")
public class Position
implements IPosition {
    @XmlAttribute(name="date")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date date;
    @XmlAttribute(name="security")
    @XmlJavaTypeAdapter(value=SecurityAdapter.class)
    private ISecurity security;
    @XmlAttribute(name="quantity")
    private long quantity = 0L;
    @XmlAttribute(name="price")
    private double price = 0.0;

    public Position() {
    }

    public Position(ISecurity security, Long quantity, Double price) {
        this.date = new Date();
        this.security = security;
        this.quantity = quantity;
        this.price = price;
    }

    public Date getDate() {
        return this.date;
    }

    @XmlTransient
    public ISecurity getSecurity() {
        return this.security;
    }

    @XmlTransient
    public Long getQuantity() {
        return this.quantity;
    }

    @XmlTransient
    public Double getPrice() {
        return this.price;
    }

    public void add(long quantity, double price) {
        if (Math.signum(quantity) == Math.signum(this.quantity) || (double)Math.signum(this.quantity) == 0.0) {
            double total = (double)this.quantity * this.price + (double)quantity * price;
            this.quantity += quantity;
            this.price = total / (double)this.quantity;
        } else {
            this.quantity += quantity;
            if (Math.signum(quantity) == Math.signum(this.quantity)) {
                this.price = price;
            }
        }
    }
}

