/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.internal.brokers.paper.transactions;

import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipsetrader.core.Cash;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.ITransaction;
import org.eclipsetrader.internal.brokers.paper.transactions.Messages;
import org.eclipsetrader.internal.brokers.paper.types.DateTimeAdapter;
import org.eclipsetrader.internal.brokers.paper.types.DoubleValueAdapter;
import org.eclipsetrader.internal.brokers.paper.types.SecurityAdapter;

@XmlRootElement(name="stock")
public class StockTransaction
implements ITransaction {
    @XmlAttribute(name="id")
    private String id;
    @XmlAttribute(name="date")
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date date;
    @XmlAttribute(name="security")
    @XmlJavaTypeAdapter(value=SecurityAdapter.class)
    private ISecurity security;
    @XmlAttribute(name="quantity")
    private Long quantity;
    @XmlAttribute(name="price")
    @XmlJavaTypeAdapter(value=DoubleValueAdapter.class)
    private Double price;

    protected StockTransaction() {
    }

    public StockTransaction(ISecurity security, Long quantity, Double price) {
        this.id = UUID.randomUUID().toString();
        this.date = new Date();
        this.security = security;
        this.quantity = quantity;
        this.price = price;
    }

    @XmlTransient
    public String getId() {
        return this.id;
    }

    @XmlTransient
    public Date getDate() {
        return this.date;
    }

    @XmlTransient
    public String getDescription() {
        return NLS.bind((String)Messages.StockTransaction_Description, (Object[])new Object[]{this.security.getName(), String.valueOf(this.quantity), String.valueOf(this.price)});
    }

    @XmlTransient
    public Cash getAmount() {
        return new Cash(Double.valueOf((double)this.quantity.longValue() * this.price), Currency.getInstance(Locale.getDefault()));
    }

    @XmlTransient
    public IOrder getOrder() {
        return null;
    }

    @XmlTransient
    public ITransaction[] getTransactions() {
        return null;
    }
}

