/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.ats.IStrategy;
import org.eclipsetrader.core.ats.ITradingSystemContext;
import org.eclipsetrader.core.charts.DataSeries;
import org.eclipsetrader.core.feed.IBar;
import org.eclipsetrader.core.feed.IPricingListener;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.core.trading.ITransaction;

public class Report {
    private final IStrategy strategy;
    private final ITradingSystemContext context;
    private final List<EquityData> equityData = new ArrayList<EquityData>();
    private final Map<ISecurity, List<IBar>> barsData = new HashMap<ISecurity, List<IBar>>();
    private final IPricingListener pricingListener = new IPricingListener(){

        @Override
        public void pricingUpdate(PricingEvent event) {
            ArrayList<IBar> bars = (ArrayList<IBar>)Report.this.barsData.get(event.getSecurity());
            if (bars == null) {
                bars = new ArrayList<IBar>();
                Report.this.barsData.put(event.getSecurity(), bars);
            }
            PricingDelta[] pricingDeltaArray = event.getDelta();
            int n = pricingDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    double amount;
                    PricingDelta delta;
                    block6: {
                        delta = pricingDeltaArray[n2];
                        if (!(delta.getNewValue() instanceof IBar)) break block5;
                        bars.add((IBar)delta.getNewValue());
                        amount = Report.this.calculateCurrentEquity();
                        if (amount == 0.0) break block5;
                        if (Report.this.equityData.size() == 0) break block6;
                        EquityData lastData = (EquityData)Report.this.equityData.get(Report.this.equityData.size() - 1);
                        if (lastData.amount == amount) break block5;
                    }
                    Report.this.equityData.add(new EquityData(((IBar)delta.getNewValue()).getDate(), amount));
                }
                ++n2;
            }
        }
    };

    public Report(IStrategy strategy, ITradingSystemContext context) {
        this.strategy = strategy;
        this.context = context;
        context.getPricingEnvironment().addPricingListener(this.pricingListener);
    }

    public void dispose() {
        this.context.getPricingEnvironment().removePricingListener(this.pricingListener);
        this.equityData.clear();
    }

    public IStrategy getStrategy() {
        return this.strategy;
    }

    public DataSeries getEquityData() {
        DataSeries result = new DataSeries("Performance", this.equityData.toArray(new IAdaptable[this.equityData.size()]));
        result.setHighest(result.getHighest());
        result.setLowest(result.getLowest());
        return result;
    }

    double calculateCurrentEquity() {
        double result = this.context.getAccount().getBalance().getAmount();
        IPosition[] iPositionArray = this.context.getAccount().getPositions();
        int n = iPositionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPosition position = iPositionArray[n2];
            ITrade trade = this.context.getPricingEnvironment().getTrade(position.getSecurity());
            result += (double)position.getQuantity().longValue() * trade.getPrice();
            ++n2;
        }
        return result;
    }

    public List<ITransaction> getTradesData() {
        return Arrays.asList(this.context.getAccount().getTransactions());
    }

    public Map<ISecurity, List<IBar>> getBarsData() {
        return this.barsData;
    }

    private class EquityData
    implements IAdaptable {
        final Date date;
        final Double amount;

        public EquityData(Date date, Double amount) {
            this.date = date;
            this.amount = amount;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isAssignableFrom(Date.class)) {
                return this.date;
            }
            if (adapter.isAssignableFrom(Double.class)) {
                return this.amount;
            }
            if (adapter.isAssignableFrom(this.getClass())) {
                return this;
            }
            return null;
        }
    }
}

