/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.engines;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.ats.IScriptStrategy;
import org.eclipsetrader.core.ats.engines.BarsDataSeriesFunction;
import org.eclipsetrader.core.ats.engines.HasPositionFunction;
import org.eclipsetrader.core.ats.engines.LimitOrderFunction;
import org.eclipsetrader.core.ats.engines.MarketOrderFunction;
import org.eclipsetrader.core.feed.Bar;
import org.eclipsetrader.core.feed.IBar;
import org.eclipsetrader.core.feed.IBarOpen;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.trading.IPosition;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class JavaScriptEngineInstrument {
    public static final String FUNCTION_ON_STRATEGY_START = "onStrategyStart";
    public static final String FUNCTION_ON_QUOTE = "onQuote";
    public static final String FUNCTION_ON_TRADE = "onTrade";
    public static final String FUNCTION_ON_BAR_OPEN = "onBarOpen";
    public static final String FUNCTION_ON_BAR = "onBar";
    public static final String FUNCTION_ON_POSITION_OPENED = "onPositionOpened";
    public static final String FUNCTION_ON_POSITION_CHANGED = "onPositionChanged";
    public static final String FUNCTION_ON_POSITION_CLOSED = "onPositionClosed";
    public static final String PROPERTY_QUOTE = "quote";
    public static final String PROPERTY_TRADE = "trade";
    public static final String PROPERTY_BAR = "bar";
    public static final String PROPERTY_BARS = "bars";
    public static final String PROPERTY_POSITION = "position";
    private final Scriptable scope;
    private final ISecurity instrument;
    private final IScriptStrategy strategy;
    private Function onQuote;
    private Function onTrade;
    private Function onBarOpen;
    private Function onBar;
    private Function onPositionOpened;
    private Function onPositionChanged;
    private Function onPositionClosed;
    private BarsDataSeriesFunction bars;
    private final Log log = LogFactory.getLog(this.getClass());

    public JavaScriptEngineInstrument(Scriptable sharedScope, ISecurity instrument, IScriptStrategy strategy) throws Exception {
        this.instrument = instrument;
        this.strategy = strategy;
        Context cx = Context.enter();
        try {
            this.scope = cx.newObject(sharedScope);
            this.scope.setPrototype(sharedScope);
            Object[] objectArray = ScriptableObject.getPropertyIds((Scriptable)sharedScope);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object id = objectArray[n2];
                Object obj = ScriptableObject.getProperty((Scriptable)sharedScope, (String)((String)id));
                ScriptableObject.putProperty((Scriptable)this.scope, (String)((String)id), (Object)obj);
                ++n2;
            }
            this.scope.setParentScope(null);
            ScriptableObject.defineClass((Scriptable)this.scope, BarsDataSeriesFunction.class);
            ScriptableObject.defineClass((Scriptable)this.scope, LimitOrderFunction.class);
            ScriptableObject.defineClass((Scriptable)this.scope, MarketOrderFunction.class);
            ScriptableObject.defineClass((Scriptable)this.scope, HasPositionFunction.class);
            this.defineClasses();
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"instrument", (Object)Context.javaToJS((Object)instrument, (Scriptable)this.scope));
            this.bars = (BarsDataSeriesFunction)cx.newObject(this.scope, "BarsDataSeries");
            ScriptableObject.putProperty((Scriptable)this.scope, (String)PROPERTY_BARS, (Object)((Object)this.bars));
            cx.evaluateString(this.scope, "importPackage(org.eclipsetrader.core.feed);", strategy.getName(), 0, null);
            cx.evaluateString(this.scope, "importPackage(org.eclipsetrader.core.instruments);", strategy.getName(), 0, null);
            cx.evaluateString(this.scope, "importPackage(org.eclipsetrader.core.trading);", strategy.getName(), 0, null);
            objectArray = strategy.getIncludes();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object script = objectArray[n2];
                cx.evaluateString(this.scope, script.getText(), script.getName(), 1, null);
                ++n2;
            }
            cx.evaluateString(this.scope, strategy.getText(), strategy.getName(), 1, null);
            Object obj = this.scope.get(FUNCTION_ON_QUOTE, this.scope);
            if (obj instanceof Function) {
                this.onQuote = (Function)obj;
            }
            if ((obj = this.scope.get(FUNCTION_ON_TRADE, this.scope)) instanceof Function) {
                this.onTrade = (Function)obj;
            }
            if ((obj = this.scope.get(FUNCTION_ON_BAR_OPEN, this.scope)) instanceof Function) {
                this.onBarOpen = (Function)obj;
            }
            if ((obj = this.scope.get(FUNCTION_ON_BAR, this.scope)) instanceof Function) {
                this.onBar = (Function)obj;
            }
            if ((obj = this.scope.get(FUNCTION_ON_POSITION_OPENED, this.scope)) instanceof Function) {
                this.onPositionOpened = (Function)obj;
            }
            if ((obj = this.scope.get(FUNCTION_ON_POSITION_CHANGED, this.scope)) instanceof Function) {
                this.onPositionChanged = (Function)obj;
            }
            if ((obj = this.scope.get(FUNCTION_ON_POSITION_CLOSED, this.scope)) instanceof Function) {
                this.onPositionClosed = (Function)obj;
            }
        }
        finally {
            Context.exit();
        }
    }

    protected void defineClasses() {
        if (!Platform.isRunning() || Platform.getExtensionRegistry() == null) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipsetrader.core.ats.javascript");
        if (extensionPoint != null) {
            IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String strID = configElements[j].getAttribute("class");
                try {
                    ScriptableObject object = (ScriptableObject)configElements[j].createExecutableExtension("class");
                    ScriptableObject.defineClass((Scriptable)this.scope, object.getClass());
                }
                catch (Exception e) {
                    Status status = new Status(2, "org.eclipsetrader.core", 0, "Unable to define function " + strID, (Throwable)e);
                    CoreActivator.log((IStatus)status);
                }
                ++j;
            }
        }
    }

    public ISecurity getInstrument() {
        return this.instrument;
    }

    public void onStrategyStart() {
        Context cx = Context.enter();
        try {
            Object obj = this.scope.get(FUNCTION_ON_STRATEGY_START, this.scope);
            if (obj instanceof Function) {
                ((Function)obj).call(cx, this.scope, this.scope, new Object[0]);
            }
        }
        finally {
            Context.exit();
        }
    }

    public void onQuote(IQuote quote) {
        Context cx = Context.enter();
        try {
            if (this.onQuote != null) {
                this.onQuote.call(cx, this.scope, this.scope, new Object[]{quote});
            }
            ScriptableObject.putProperty((Scriptable)this.scope, (String)PROPERTY_QUOTE, (Object)quote);
        }
        finally {
            Context.exit();
        }
    }

    public void onTrade(ITrade trade) {
        Context cx = Context.enter();
        try {
            if (this.onTrade != null) {
                this.onTrade.call(cx, this.scope, this.scope, new Object[]{trade});
            }
            ScriptableObject.putProperty((Scriptable)this.scope, (String)PROPERTY_TRADE, (Object)trade);
        }
        finally {
            Context.exit();
        }
    }

    public void onBarOpen(IBarOpen bar) {
        Context cx = Context.enter();
        try {
            if (this.onBarOpen != null) {
                this.onBarOpen.call(cx, this.scope, this.scope, new Object[]{bar});
            }
        }
        finally {
            Context.exit();
        }
    }

    public void onBar(IBar bar) {
        Context cx = Context.enter();
        try {
            this.bars.append(bar);
            if (this.onBar != null) {
                this.onBar.call(cx, this.scope, this.scope, new Object[]{bar});
            }
            ScriptableObject.putProperty((Scriptable)this.scope, (String)PROPERTY_BAR, (Object)bar);
        }
        finally {
            Context.exit();
        }
    }

    public void onPositionOpen(IPosition position) {
        this.log.info((Object)("onPositionOpen: " + position));
        Context cx = Context.enter();
        try {
            ScriptableObject.putProperty((Scriptable)this.scope, (String)PROPERTY_POSITION, (Object)position);
            if (this.onPositionOpened != null) {
                this.onPositionOpened.call(cx, this.scope, this.scope, new Object[]{position});
            }
        }
        finally {
            Context.exit();
        }
    }

    public void onPositionChange(IPosition position) {
        this.log.info((Object)("onPositionChange: " + position));
        Context cx = Context.enter();
        try {
            ScriptableObject.putProperty((Scriptable)this.scope, (String)PROPERTY_POSITION, (Object)position);
            if (this.onPositionChanged != null) {
                this.onPositionChanged.call(cx, this.scope, this.scope, new Object[]{position});
            }
        }
        finally {
            Context.exit();
        }
    }

    public void onPositionClosed(IPosition position) {
        this.log.info((Object)("onPositionClosed: " + position));
        Context cx = Context.enter();
        try {
            ScriptableObject.deleteProperty((Scriptable)this.scope, (String)PROPERTY_POSITION);
            if (this.onPositionClosed != null) {
                this.onPositionClosed.call(cx, this.scope, this.scope, new Object[]{position});
            }
        }
        finally {
            Context.exit();
        }
    }

    public void setPosition(IPosition position) {
        Context.enter();
        try {
            ScriptableObject.putProperty((Scriptable)this.scope, (String)PROPERTY_POSITION, (Object)position);
        }
        finally {
            Context.exit();
        }
    }

    public Object get(String name) {
        return this.scope.get(name, this.scope);
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public IBar[] getBars() {
        return this.bars.toArray();
    }

    public void backfill(int backfillBars) {
        BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IRepositoryService.class);
        if (serviceReference != null) {
            IRepositoryService repositoryService = (IRepositoryService)context.getService(serviceReference);
            IHistory history = repositoryService.getHistoryFor(this.instrument);
            IOHLC[] ohlc = history.getOHLC();
            TimeSpan[] timeSpan = this.strategy.getBarsTimeSpan();
            int i = 0;
            while (i < timeSpan.length) {
                if (timeSpan[i].equals(TimeSpan.days(1))) {
                    int index = ohlc.length - backfillBars;
                    while (index < ohlc.length) {
                        this.bars.append(new Bar(ohlc[index].getDate(), timeSpan[i], ohlc[index].getOpen(), ohlc[index].getHigh(), ohlc[index].getLow(), ohlc[index].getClose(), ohlc[index].getVolume()));
                        ++index;
                    }
                } else {
                    int filled = 0;
                    int index = ohlc.length - 1;
                    while (index >= 0 && filled < backfillBars) {
                        IHistory subHistory = history.getSubset(ohlc[index].getDate(), ohlc[index].getDate(), timeSpan[i]);
                        IOHLC[] subOhlc = subHistory.getOHLC();
                        int ii = subOhlc.length - 1;
                        while (ii >= 0 && filled < backfillBars) {
                            this.bars.prepend(new Bar(subOhlc[ii].getDate(), timeSpan[i], subOhlc[ii].getOpen(), subOhlc[ii].getHigh(), subOhlc[ii].getLow(), subOhlc[ii].getClose(), subOhlc[ii].getVolume()));
                            ++filled;
                            --ii;
                        }
                        --index;
                    }
                }
                ++i;
            }
            context.ungetService(serviceReference);
        }
    }
}

