/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.simulation;

import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.IPosition;

public class Position
implements IPosition {
    private final ISecurity security;
    private Long quantity;
    private Double price;

    public Position(ISecurity security, Long quantity, Double price) {
        this.security = security;
        this.quantity = quantity;
        this.price = price;
    }

    public void add(Long quantity, Double price) {
        if (Math.signum(quantity.longValue()) == Math.signum(this.quantity.longValue()) || (double)Math.signum(this.quantity.longValue()) == 0.0) {
            double total = (double)this.quantity.longValue() * this.price + (double)quantity.longValue() * price;
            this.quantity = this.quantity + quantity;
            this.price = total / (double)this.quantity.longValue();
        } else {
            this.quantity = this.quantity + quantity;
            if (Math.signum(quantity.longValue()) == Math.signum(this.quantity.longValue())) {
                this.price = price;
            }
        }
    }

    @Override
    public ISecurity getSecurity() {
        return this.security;
    }

    @Override
    public Long getQuantity() {
        return this.quantity;
    }

    @Override
    public Double getPrice() {
        return this.price;
    }

    public String toString() {
        return "Position: instrument=" + this.security + ", qty=" + this.quantity + ", price=" + this.price;
    }
}

