/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.ats.simulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipsetrader.core.ats.IScriptStrategy;
import org.eclipsetrader.core.ats.simulation.Account;
import org.eclipsetrader.core.ats.simulation.Broker;
import org.eclipsetrader.core.ats.simulation.SimulationContext;
import org.eclipsetrader.core.ats.simulation.SimulationReport;
import org.eclipsetrader.core.feed.Bar;
import org.eclipsetrader.core.feed.BarOpen;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.PricingEnvironment;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.feed.Trade;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.ats.TradingSystem;
import org.eclipsetrader.core.repositories.IRepositoryService;

public class SimulationRunner {
    private final IRepositoryService repositoryService;
    private final IScriptStrategy strategy;
    private Date begin;
    private Date end;
    private SimulationReport report;

    public SimulationRunner(IRepositoryService repositoryService, IScriptStrategy strategy, Date begin, Date end) {
        this.repositoryService = repositoryService;
        this.strategy = strategy;
        this.begin = begin;
        this.end = end;
    }

    public void runWithProgress(IProgressMonitor monitor) throws Exception {
        TimeSpan[] barsTimeSpan = this.strategy.getBarsTimeSpan();
        if (barsTimeSpan == null || barsTimeSpan.length == 0) {
            barsTimeSpan = new TimeSpan[]{TimeSpan.days(1)};
        }
        ArrayList<BarData> dataSet = new ArrayList<BarData>();
        ISecurity[] iSecurityArray = this.strategy.getInstruments();
        int n = iSecurityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISecurity security = iSecurityArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            IHistory history = this.repositoryService.getHistoryFor(security);
            TimeSpan[] timeSpanArray = barsTimeSpan;
            int n3 = barsTimeSpan.length;
            int n4 = 0;
            while (n4 < n3) {
                TimeSpan timeSpan = timeSpanArray[n4];
                IHistory subHistory = history.getSubset(this.begin, this.end, timeSpan);
                IOHLC[] iOHLCArray = subHistory.getOHLC();
                int n5 = iOHLCArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IOHLC ohlc = iOHLCArray[n6];
                    dataSet.add(new BarData(security, timeSpan, ohlc));
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        Collections.sort(dataSet);
        PricingEnvironment pricingEnvironment = new PricingEnvironment();
        Broker broker = new Broker(pricingEnvironment);
        broker.connect();
        Account account = new Account();
        SimulationContext context = new SimulationContext(broker, account, pricingEnvironment);
        this.report = new SimulationReport(this.strategy, context, this.begin, this.end);
        TradingSystem tradingSystem = new TradingSystem(this.strategy);
        tradingSystem.start(context);
        Iterator iter = dataSet.iterator();
        while (iter.hasNext() && !monitor.isCanceled()) {
            BarData data = (BarData)iter.next();
            pricingEnvironment.setTrade(data.security, new Trade(data.bar.getDate(), data.bar.getOpen(), 0L, 0L));
            pricingEnvironment.setBarOpen(data.security, new BarOpen(data.bar.getDate(), data.timeSpan, data.bar.getOpen()));
            pricingEnvironment.setTrade(data.security, new Trade(data.bar.getDate(), data.bar.getClose(), 0L, 0L));
            pricingEnvironment.setBar(data.security, new Bar(data.bar.getDate(), data.timeSpan, data.bar.getOpen(), data.bar.getHigh(), data.bar.getLow(), data.bar.getClose(), data.bar.getVolume()));
        }
        tradingSystem.stop();
        broker.disconnect();
        context.dispose();
    }

    public SimulationReport getReport() {
        return this.report;
    }

    private class BarData
    implements Comparable<BarData> {
        ISecurity security;
        TimeSpan timeSpan;
        IOHLC bar;

        public BarData(ISecurity security, TimeSpan timeSpan, IOHLC bar) {
            this.security = security;
            this.timeSpan = timeSpan;
            this.bar = bar;
        }

        @Override
        public int compareTo(BarData o) {
            return this.bar.getDate().compareTo(o.bar.getDate());
        }
    }
}

