/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.charts;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.IDataSeriesVisitor;
import org.eclipsetrader.core.feed.IOHLC;

public class DataSeries
implements IDataSeries {
    private final String name;
    private final IAdaptable[] values;
    private IAdaptable first;
    private IAdaptable last;
    private IAdaptable highest;
    private IAdaptable lowest;
    private IDataSeries[] childrens;
    private boolean highestOverride = false;
    private boolean lowestOverride = false;

    public DataSeries(String name, IAdaptable[] values) {
        this.name = name;
        this.values = values;
        this.accept(new RangeVisitor());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IAdaptable getFirst() {
        return this.first;
    }

    @Override
    public IAdaptable getLast() {
        return this.last;
    }

    @Override
    public IAdaptable getHighest() {
        return this.highest;
    }

    public void setHighest(IAdaptable highest) {
        this.highest = highest;
        this.highestOverride = true;
    }

    protected boolean isHighestOverride() {
        return this.highestOverride;
    }

    @Override
    public IAdaptable getLowest() {
        return this.lowest;
    }

    public void setLowest(IAdaptable lowest) {
        this.lowest = lowest;
        this.lowestOverride = true;
    }

    protected boolean isLowestOverride() {
        return this.lowestOverride;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public IAdaptable[] getValues() {
        return this.values;
    }

    @Override
    public IDataSeries getSeries(IAdaptable first, IAdaptable last) {
        DataSeries series = new DataSeries(this.getName(), this.getSubset(first, last));
        if (this.highestOverride) {
            series.setHighest(this.getHighest());
        }
        if (this.lowestOverride) {
            series.setLowest(this.getLowest());
        }
        return series;
    }

    protected IAdaptable[] getSubset(IAdaptable first, IAdaptable last) {
        Date firstValue = first != null ? (Date)first.getAdapter(Date.class) : null;
        Date lastValue = last != null ? (Date)last.getAdapter(Date.class) : null;
        ArrayList<IAdaptable> list = new ArrayList<IAdaptable>(this.values.length);
        int i = 0;
        while (i < this.values.length) {
            Date date = (Date)this.values[i].getAdapter(Date.class);
            if (!(firstValue != null && date.before(firstValue) || lastValue != null && date.after(lastValue))) {
                list.add(this.values[i]);
            }
            ++i;
        }
        return list.toArray(new IAdaptable[list.size()]);
    }

    @Override
    public int cross(IDataSeries series, IAdaptable value) {
        if (this.values.length <= 1 || series.size() <= 1) {
            return 0;
        }
        int index = this.indexOf(this, value);
        if (index <= 0) {
            return 0;
        }
        int otherIndex = this.indexOf(series, value);
        if (otherIndex <= 0) {
            return 0;
        }
        Number ourValue = (Number)this.values[index - 1].getAdapter(Number.class);
        Number ourNextValue = (Number)this.values[index].getAdapter(Number.class);
        Number otherValue = (Number)series.getValues()[otherIndex - 1].getAdapter(Number.class);
        Number otherNextValue = (Number)series.getValues()[otherIndex].getAdapter(Number.class);
        if (ourValue.doubleValue() < otherValue.doubleValue() && ourNextValue.doubleValue() > otherNextValue.doubleValue()) {
            return 1;
        }
        if (ourValue.doubleValue() > otherValue.doubleValue() && ourNextValue.doubleValue() < otherNextValue.doubleValue()) {
            return -1;
        }
        return 0;
    }

    protected int indexOf(IDataSeries series, IAdaptable value) {
        IAdaptable[] values = series.getValues();
        Date valueDate = (Date)value.getAdapter(Date.class);
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(value)) {
                return i;
            }
            Date date = (Date)values[i].getAdapter(Date.class);
            if (date != null && date.equals(valueDate)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public IDataSeries[] getChildren() {
        return this.childrens;
    }

    @Override
    public void setChildren(IDataSeries[] childrens) {
        this.childrens = childrens;
        this.first = null;
        this.last = null;
        this.highest = null;
        this.lowest = null;
        this.accept(new RangeVisitor());
    }

    @Override
    public void accept(IDataSeriesVisitor visitor) {
        if (visitor.visit(this) && this.childrens != null) {
            int i = 0;
            while (i < this.childrens.length) {
                this.childrens[i].accept(visitor);
                ++i;
            }
        }
    }

    private class RangeVisitor
    implements IDataSeriesVisitor {
        private Double lowestValue;
        private Double highestValue;
        private Date firstValue;
        private Date lastValue;

        @Override
        public boolean visit(IDataSeries data) {
            IAdaptable[] iAdaptableArray = data.getValues();
            int n = iAdaptableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable v = iAdaptableArray[n2];
                IOHLC ohlc = (IOHLC)v.getAdapter(IOHLC.class);
                if (ohlc != null) {
                    this.updateHighestLowest(ohlc.getLow() != null ? ohlc.getLow() : ohlc.getClose(), v);
                    this.updateHighestLowest(ohlc.getHigh() != null ? ohlc.getHigh() : ohlc.getClose(), v);
                    if (ohlc.getDate() != null) {
                        this.updateFirstLast(ohlc.getDate(), v);
                    }
                } else {
                    Number value = (Number)v.getAdapter(Number.class);
                    this.updateHighestLowest(value, v);
                    Date date = (Date)v.getAdapter(Date.class);
                    if (date != null) {
                        this.updateFirstLast(date, v);
                    }
                }
                ++n2;
            }
            if (data instanceof DataSeries) {
                if (((DataSeries)data).highestOverride) {
                    DataSeries.this.highest = data.getHighest();
                }
                if (((DataSeries)data).lowestOverride) {
                    DataSeries.this.lowest = data.getLowest();
                }
            }
            return true;
        }

        private void updateHighestLowest(Number value, IAdaptable reference) {
            if (this.lowestValue == null || value.doubleValue() < this.lowestValue) {
                this.lowestValue = value.doubleValue();
                DataSeries.this.lowest = reference;
            }
            if (this.highestValue == null || value.doubleValue() > this.highestValue) {
                this.highestValue = value.doubleValue();
                DataSeries.this.highest = reference;
            }
        }

        private void updateFirstLast(Date date, IAdaptable reference) {
            if (this.firstValue == null || date.before(this.firstValue)) {
                this.firstValue = date;
                DataSeries.this.first = reference;
            }
            if (this.lastValue == null || date.after(this.lastValue)) {
                this.lastValue = date;
                DataSeries.this.last = reference;
            }
        }
    }
}

