/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.charts;

import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.charts.DataSeries;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.NumberValue;

public class NumericDataSeries
extends DataSeries {
    public NumericDataSeries(String name, Number[] values, IDataSeries parent) {
        super(name, NumericDataSeries.convertValues(values, parent));
    }

    public NumericDataSeries(String name, double[] values, IDataSeries parent) {
        super(name, NumericDataSeries.convertValues(values, parent));
    }

    public NumericDataSeries(String name, int[] values, IDataSeries parent) {
        super(name, NumericDataSeries.convertValues(values, parent));
    }

    public NumericDataSeries(String name, long[] values, IDataSeries parent) {
        super(name, NumericDataSeries.convertValues(values, parent));
    }

    protected NumericDataSeries(String name, IAdaptable[] values) {
        super(name, values);
    }

    private static IAdaptable[] convertValues(Number[] values, IDataSeries parent) {
        IAdaptable[] reference = parent.getValues();
        int refIndex = reference.length - values.length;
        IAdaptable[] v = new IAdaptable[values.length];
        int i = 0;
        while (i < values.length) {
            Date date = (Date)reference[refIndex].getAdapter(Date.class);
            v[i] = new NumberValue(date, values[i]);
            ++i;
            ++refIndex;
        }
        return v;
    }

    private static IAdaptable[] convertValues(double[] values, IDataSeries parent) {
        IAdaptable[] reference = parent.getValues();
        int refIndex = reference.length - values.length;
        IAdaptable[] v = new IAdaptable[values.length];
        int i = 0;
        while (i < values.length) {
            Date date = (Date)reference[refIndex].getAdapter(Date.class);
            v[i] = new NumberValue(date, values[i]);
            ++i;
            ++refIndex;
        }
        return v;
    }

    private static IAdaptable[] convertValues(int[] values, IDataSeries parent) {
        IAdaptable[] reference = parent.getValues();
        int refIndex = reference.length - values.length;
        IAdaptable[] v = new IAdaptable[values.length];
        int i = 0;
        while (i < values.length) {
            Date date = (Date)reference[refIndex].getAdapter(Date.class);
            v[i] = new NumberValue(date, values[i]);
            ++i;
            ++refIndex;
        }
        return v;
    }

    private static IAdaptable[] convertValues(long[] values, IDataSeries parent) {
        IAdaptable[] reference = parent.getValues();
        int refIndex = reference.length - values.length;
        IAdaptable[] v = new IAdaptable[values.length];
        int i = 0;
        while (i < values.length) {
            Date date = (Date)reference[refIndex].getAdapter(Date.class);
            v[i] = new NumberValue(date, values[i]);
            ++i;
            ++refIndex;
        }
        return v;
    }

    @Override
    public IDataSeries getSeries(IAdaptable first, IAdaptable last) {
        NumericDataSeries series = new NumericDataSeries(this.getName(), this.getSubset(first, last));
        if (this.isHighestOverride()) {
            series.setHighest(this.getHighest());
        }
        if (this.isLowestOverride()) {
            series.setLowest(this.getLowest());
        }
        return series;
    }
}

