/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.charts;

import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.charts.DataSeries;
import org.eclipsetrader.core.charts.IDataSeries;
import org.eclipsetrader.core.charts.NumberValue;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.TimeSpan;

public class OHLCDataSeries
extends DataSeries {
    private TimeSpan resolution;

    private static IAdaptable[] convertValues(IOHLC[] values) {
        IAdaptable[] v = new OHLCWrapper[values.length];
        int i = 0;
        while (i < values.length) {
            v[i] = new OHLCWrapper(values[i]);
            ++i;
        }
        return v;
    }

    public OHLCDataSeries(String name, IOHLC[] values, TimeSpan resolution) {
        super(name, OHLCDataSeries.convertValues(values));
        this.resolution = resolution;
    }

    protected OHLCDataSeries(String name, IAdaptable[] values, TimeSpan resolution) {
        super(name, values);
        this.resolution = resolution;
    }

    @Override
    public IDataSeries getSeries(IAdaptable first, IAdaptable last) {
        return new OHLCDataSeries(this.getName(), this.getSubset(first, last), this.resolution);
    }

    @Override
    public IAdaptable getHighest() {
        IOHLC ohlc;
        IAdaptable v = super.getHighest();
        if (v != null && (ohlc = (IOHLC)v.getAdapter(IOHLC.class)) != null) {
            v = new NumberValue(ohlc.getDate(), ohlc.getHigh());
        }
        return v;
    }

    @Override
    public IAdaptable getLowest() {
        IOHLC ohlc;
        IAdaptable v = super.getLowest();
        if (v != null && (ohlc = (IOHLC)v.getAdapter(IOHLC.class)) != null) {
            v = new NumberValue(ohlc.getDate(), ohlc.getLow());
        }
        return v;
    }

    public TimeSpan getResolution() {
        return this.resolution;
    }

    private static class OHLCWrapper
    implements IAdaptable {
        private IOHLC ohlc;

        public OHLCWrapper(IOHLC ohlc) {
            this.ohlc = ohlc;
        }

        public Object getAdapter(Class adapter) {
            if (this.ohlc != null && adapter.isAssignableFrom(this.ohlc.getClass())) {
                return this.ohlc;
            }
            if (adapter.isAssignableFrom(Date.class)) {
                return this.ohlc.getDate();
            }
            if (adapter.isAssignableFrom(Double.class) || adapter.isAssignableFrom(Number.class)) {
                return this.ohlc.getClose();
            }
            return null;
        }
    }
}

