/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.feed;

import java.util.Calendar;
import java.util.Date;
import java.util.Observable;
import org.eclipsetrader.core.feed.Bar;
import org.eclipsetrader.core.feed.BarOpen;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.TimeSpan;

public class BarGenerator
extends Observable {
    private TimeSpan timeSpan;
    Date dateOpen;
    Double open;
    Double high;
    Double low;
    Double close;
    Long volume;
    Date dateClose;
    private Calendar calendar = Calendar.getInstance();

    public BarGenerator(TimeSpan timeSpan) {
        this.timeSpan = timeSpan;
    }

    public void addTrade(ITrade trade) {
        if (trade.getTime() == null) {
            return;
        }
        this.calendar.setTime(trade.getTime());
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        if (this.dateOpen != null && this.dateClose != null) {
            Date time = this.calendar.getTime();
            if (!time.before(this.dateOpen) && time.before(this.dateClose)) {
                if (this.high == null || trade.getPrice() > this.high) {
                    this.high = trade.getPrice();
                }
                if (this.low == null || trade.getPrice() < this.low) {
                    this.low = trade.getPrice();
                }
                this.close = trade.getPrice();
                if (trade.getSize() != null) {
                    this.volume = this.volume != null ? this.volume + trade.getSize() : trade.getSize();
                }
            }
            if (!time.before(this.dateClose)) {
                this.setChanged();
                this.notifyObservers(new Bar(this.dateOpen, this.timeSpan, this.open, this.high, this.low, this.close, this.volume));
                this.dateOpen = null;
            }
        }
        if (this.dateOpen == null) {
            int round = this.calendar.get(12) % this.timeSpan.getLength();
            this.calendar.add(12, -round);
            this.dateOpen = this.calendar.getTime();
            this.calendar.add(12, this.timeSpan.getLength());
            this.dateClose = this.calendar.getTime();
            this.open = trade.getPrice();
            this.high = trade.getPrice();
            this.low = trade.getPrice();
            this.close = trade.getPrice();
            this.volume = trade.getSize();
            this.setChanged();
            this.notifyObservers(new BarOpen(this.dateOpen, this.timeSpan, this.open));
        }
    }

    public void forceBarClose() {
        if (this.dateOpen == null) {
            return;
        }
        this.setChanged();
        this.notifyObservers(new Bar(this.dateOpen, this.timeSpan, this.open, this.high, this.low, this.close, this.volume));
        this.dateOpen = null;
    }

    public boolean isBarExpired() {
        if (this.dateOpen == null || this.dateClose == null) {
            return false;
        }
        return new Date().after(this.dateClose);
    }
}

