/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.feed;

import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipsetrader.core.feed.HistoryDay;
import org.eclipsetrader.core.feed.IDividend;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.ISplit;
import org.eclipsetrader.core.feed.OHLC;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.repositories.StoreProperties;

public class History
implements IHistory,
IStoreObject {
    private ISecurity security;
    private IOHLC[] bars = new IOHLC[0];
    private ISplit[] splits = new ISplit[0];
    private TimeSpan timeSpan;
    private IOHLC highest;
    private IOHLC lowest;
    private IStore store;
    private IStoreProperties storeProperties;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Map<Key, WeakReference<HistoryDay>> historyMap = new HashMap<Key, WeakReference<HistoryDay>>();

    protected History() {
    }

    public History(ISecurity security, IOHLC[] bars) {
        this(security, bars, null, TimeSpan.days(1));
    }

    public History(ISecurity security, IOHLC[] bars, TimeSpan timeSpan) {
        this.timeSpan = timeSpan;
        this.setSecurity(security);
        this.setOHLC(bars);
    }

    public History(ISecurity security, IOHLC[] bars, ISplit[] splits, TimeSpan timeSpan) {
        this.timeSpan = timeSpan;
        this.setSecurity(security);
        this.setOHLC(bars);
        this.setSplits(splits);
    }

    public History(IStore store, IStoreProperties storeProperties) {
        this.setStore(store);
        this.setStoreProperties(storeProperties);
    }

    @Override
    public ISecurity getSecurity() {
        return this.security;
    }

    protected void setSecurity(ISecurity security) {
        this.security = security;
    }

    @Override
    public IOHLC getFirst() {
        return this.bars != null && this.bars.length != 0 ? this.bars[0] : null;
    }

    @Override
    public IOHLC getLast() {
        return this.bars != null && this.bars.length != 0 ? this.bars[this.bars.length - 1] : null;
    }

    @Override
    public IOHLC getHighest() {
        return this.highest;
    }

    @Override
    public IOHLC getLowest() {
        return this.lowest;
    }

    @Override
    public IOHLC[] getOHLC() {
        return this.bars;
    }

    public void setOHLC(IOHLC[] bars) {
        if (Arrays.equals(this.bars, bars)) {
            return;
        }
        IOHLC[] oldBars = this.bars;
        ArrayList<IOHLC> l = new ArrayList<IOHLC>(Arrays.asList(bars));
        Collections.sort(l, new Comparator<IOHLC>(){

            @Override
            public int compare(IOHLC o1, IOHLC o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        this.bars = l.toArray(new IOHLC[l.size()]);
        this.updateRange();
        this.updateSubsets();
        this.propertyChangeSupport.firePropertyChange("bars", oldBars, this.bars);
    }

    @Override
    public IHistory getSubset(Date first, Date last) {
        HistoryDay history;
        Key key = new Key(first, last, this.timeSpan);
        WeakReference<HistoryDay> reference = this.historyMap.get(key);
        HistoryDay historyDay = history = reference != null ? (HistoryDay)reference.get() : null;
        if (history != null) {
            return history;
        }
        IOHLC[] subset = this.getOHLCSubset(first, last);
        history = new HistoryDay(this.security, this.timeSpan, subset);
        this.historyMap.put(key, new WeakReference<HistoryDay>(history));
        return history;
    }

    private IOHLC[] getOHLCSubset(Date first, Date last) {
        ArrayList<IOHLC> l = new ArrayList<IOHLC>();
        IOHLC[] iOHLCArray = this.bars;
        int n = this.bars.length;
        int n2 = 0;
        while (n2 < n) {
            IOHLC b = iOHLCArray[n2];
            if (!(first != null && b.getDate().before(first) || last != null && b.getDate().after(last))) {
                l.add(b);
            }
            ++n2;
        }
        return l.toArray(new IOHLC[l.size()]);
    }

    @Override
    public IHistory getSubset(Date first, Date last, TimeSpan timeSpan) {
        IStore[] childStores;
        HistoryDay history;
        if (this.timeSpan != null && this.timeSpan.equals(timeSpan)) {
            return this.getSubset(first, last);
        }
        Key key = new Key(first, last, timeSpan);
        WeakReference<HistoryDay> reference = this.historyMap.get(key);
        HistoryDay historyDay = history = reference != null ? (HistoryDay)reference.get() : null;
        if (history != null) {
            return history;
        }
        Calendar c = Calendar.getInstance();
        if (first != null) {
            c.setTime(first);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            first = c.getTime();
        }
        if (last != null) {
            c.setTime(last);
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            c.set(14, 999);
            last = c.getTime();
        }
        ArrayList<IStore> storeList = new ArrayList<IStore>();
        ArrayList<IStoreProperties> propertyList = new ArrayList<IStoreProperties>();
        if (this.store != null && (childStores = this.store.fetchChilds(null)) != null) {
            IStore[] iStoreArray = childStores;
            int n = childStores.length;
            int n2 = 0;
            while (n2 < n) {
                IStore childStore = iStoreArray[n2];
                IStoreProperties properties = childStore.fetchProperties(null);
                Date barsDate = (Date)properties.getProperty("bars-date");
                if (!(first != null && barsDate.before(first) || last != null && barsDate.after(last))) {
                    storeList.add(childStore);
                    propertyList.add(properties);
                }
                ++n2;
            }
        }
        IStoreProperties[] properties = propertyList.toArray(new IStoreProperties[propertyList.size()]);
        history = new HistoryDay(this.security, timeSpan, storeList.toArray(new IStore[storeList.size()]), properties){

            @Override
            protected IStoreObject[] updateStoreObjects() {
                IStoreObject[] storeObject = super.updateStoreObjects();
                Set set = History.this.historyMap.entrySet();
                Map.Entry[] entry = set.toArray(new Map.Entry[set.size()]);
                HashSet<Key> updatedElements = new HashSet<Key>();
                TimeSpan skipTimeSpan = TimeSpan.days(1);
                int ii = 0;
                while (ii < storeObject.length) {
                    Date barsDate = (Date)storeObject[ii].getStoreProperties().getProperty("bars-date");
                    int i = 0;
                    while (i < entry.length) {
                        HistoryDay element = (HistoryDay)((WeakReference)entry[i].getValue()).get();
                        Key key = (Key)entry[i].getKey();
                        if (element != null && element != this && !element.getTimeSpan().equals(skipTimeSpan) && ((Key)entry[i].getKey()).isInRange(barsDate)) {
                            updatedElements.add(key);
                        }
                        ++i;
                    }
                    ++ii;
                }
                for (Key key : updatedElements) {
                    IStore[] childStores;
                    HistoryDay element = (HistoryDay)((WeakReference)History.this.historyMap.get(key)).get();
                    if (element == null) continue;
                    HashMap<Date, IStore> storeList = new HashMap<Date, IStore>();
                    HashMap<Date, IStoreProperties> propertyList = new HashMap<Date, IStoreProperties>();
                    IStore[] iStoreArray = childStores = History.this.store != null ? History.this.store.fetchChilds(null) : null;
                    if (childStores != null) {
                        IStore[] iStoreArray2 = childStores;
                        int n = childStores.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStore childStore = iStoreArray2[n2];
                            IStoreProperties properties = childStore.fetchProperties(null);
                            Date barsDate = (Date)properties.getProperty("bars-date");
                            if (key.isInRange(barsDate)) {
                                storeList.put(barsDate, childStore);
                                propertyList.put(barsDate, properties);
                            }
                            ++n2;
                        }
                    }
                    int i = 0;
                    while (i < storeObject.length) {
                        Date barsDate = (Date)storeObject[i].getStoreProperties().getProperty("bars-date");
                        if (key.isInRange(barsDate)) {
                            storeList.put(barsDate, storeObject[i].getStore());
                            propertyList.put(barsDate, storeObject[i].getStoreProperties());
                        }
                        ++i;
                    }
                    Collection s = storeList.values();
                    Collection p = propertyList.values();
                    element.setStoreProperties(s.toArray(new IStore[s.size()]), p.toArray(new IStoreProperties[p.size()]));
                }
                return storeObject;
            }
        };
        this.historyMap.put(key, new WeakReference<HistoryDay>(history));
        return history;
    }

    @Override
    public IHistory[] getDay(Date date) {
        IStore[] childStores;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        date = c.getTime();
        IStore dayStore = null;
        IStoreProperties dayProperties = null;
        if (this.store != null && (childStores = this.store.fetchChilds(null)) != null) {
            int i = 0;
            while (i < childStores.length) {
                IStoreProperties childProperties = childStores[i].fetchProperties(null);
                Date barsDate = (Date)childProperties.getProperty("bars-date");
                if (date.equals(barsDate)) {
                    dayStore = childStores[i];
                    dayProperties = childProperties;
                    break;
                }
                ++i;
            }
        }
        if (dayStore == null || dayProperties == null) {
            return new IHistory[0];
        }
        ArrayList<HistoryDay> l = new ArrayList<HistoryDay>();
        String[] propertyNames = dayProperties.getPropertyNames();
        int i = 0;
        while (i < propertyNames.length) {
            TimeSpan timeSpan;
            Object value = dayProperties.getProperty(propertyNames[i]);
            if (value instanceof IOHLC[] && (timeSpan = TimeSpan.fromString(propertyNames[i])) != null) {
                HistoryDay history;
                Key key = new Key(date, date, timeSpan);
                WeakReference<HistoryDay> reference = this.historyMap.get(key);
                HistoryDay historyDay = history = reference != null ? (HistoryDay)reference.get() : null;
                if (history == null) {
                    IStore[] storeList = new IStore[]{dayStore};
                    IStoreProperties[] propertiesList = new IStoreProperties[]{dayProperties};
                    history = this.createHistoryDay(storeList, propertiesList, timeSpan);
                    this.historyMap.put(key, new WeakReference<HistoryDay>(history));
                }
                l.add(history);
            }
            ++i;
        }
        return l.toArray(new IHistory[l.size()]);
    }

    private HistoryDay createHistoryDay(IStore[] storeList, IStoreProperties[] propertiesList, TimeSpan timeSpan) {
        HistoryDay history = new HistoryDay(this.security, timeSpan, storeList, propertiesList){

            @Override
            protected IStoreObject[] updateStoreObjects() {
                IStoreObject[] storeObject = super.updateStoreObjects();
                Set set = History.this.historyMap.entrySet();
                Map.Entry[] entry = set.toArray(new Map.Entry[set.size()]);
                HashSet<Key> updatedElements = new HashSet<Key>();
                int ii = 0;
                while (ii < storeObject.length) {
                    TimeSpan timeSpan = (TimeSpan)storeObject[ii].getStoreProperties().getProperty("bars-time-span");
                    Date barsDate = (Date)storeObject[ii].getStoreProperties().getProperty("bars-date");
                    int i = 0;
                    while (i < entry.length) {
                        HistoryDay element = (HistoryDay)((WeakReference)entry[i].getValue()).get();
                        Key key = (Key)entry[i].getKey();
                        if (element != null && element != this && element.getTimeSpan().equals(timeSpan) && ((Key)entry[i].getKey()).isInRange(barsDate)) {
                            updatedElements.add(key);
                        }
                        ++i;
                    }
                    ++ii;
                }
                for (Key key : updatedElements) {
                    IStore[] childStores;
                    HistoryDay element = (HistoryDay)((WeakReference)History.this.historyMap.get(key)).get();
                    if (element == null) continue;
                    HashMap<Date, IStore> storeList = new HashMap<Date, IStore>();
                    HashMap<Date, IStoreProperties> propertyList = new HashMap<Date, IStoreProperties>();
                    IStore[] iStoreArray = childStores = History.this.store != null ? History.this.store.fetchChilds(null) : null;
                    if (childStores != null) {
                        IStore[] iStoreArray2 = childStores;
                        int n = childStores.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStore childStore = iStoreArray2[n2];
                            IStoreProperties properties = childStore.fetchProperties(null);
                            Date barsDate = (Date)properties.getProperty("bars-date");
                            if (key.isInRange(barsDate)) {
                                storeList.put(barsDate, childStore);
                                propertyList.put(barsDate, properties);
                            }
                            ++n2;
                        }
                    }
                    int i = 0;
                    while (i < storeObject.length) {
                        Date barsDate = (Date)storeObject[i].getStoreProperties().getProperty("bars-date");
                        if (key.isInRange(barsDate)) {
                            storeList.put(barsDate, storeObject[i].getStore());
                            propertyList.put(barsDate, storeObject[i].getStoreProperties());
                        }
                        ++i;
                    }
                    Collection s = storeList.values();
                    Collection p = propertyList.values();
                    element.setStoreProperties(s.toArray(new IStore[s.size()]), p.toArray(new IStoreProperties[p.size()]));
                }
                return storeObject;
            }
        };
        return history;
    }

    @Override
    public TimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    @Override
    public ISplit[] getSplits() {
        return this.splits;
    }

    public void setSplits(ISplit[] splits) {
        if (Arrays.equals(this.splits, splits)) {
            return;
        }
        ISplit[] oldValue = this.splits;
        this.splits = splits;
        this.propertyChangeSupport.firePropertyChange("splits", oldValue, this.splits);
    }

    @Override
    public IOHLC[] getAdjustedOHLC() {
        IDividend[] dividends = (IDividend[])this.security.getAdapter(IDividend[].class);
        if (!(dividends != null && dividends.length != 0 || this.splits != null && this.splits.length != 0)) {
            return this.bars;
        }
        IOHLC[] l = new IOHLC[this.bars.length];
        int i = 0;
        while (i < l.length) {
            double splitFactor = 1.0;
            if (this.splits != null) {
                int s = 0;
                while (s < this.splits.length) {
                    if (this.bars[i].getDate().before(this.splits[s].getDate())) {
                        splitFactor *= this.splits[s].getNewQuantity() / this.splits[s].getOldQuantity();
                    }
                    ++s;
                }
            }
            double cumulatedDividends = 0.0;
            if (dividends != null) {
                int d = 0;
                while (d < dividends.length) {
                    if (this.bars[i].getDate().before(dividends[d].getExDate())) {
                        cumulatedDividends += dividends[d].getValue().doubleValue();
                    }
                    ++d;
                }
            }
            l[i] = new OHLC(this.bars[i].getDate(), this.bars[i].getOpen() / splitFactor - cumulatedDividends, this.bars[i].getHigh() / splitFactor - cumulatedDividends, this.bars[i].getLow() / splitFactor - cumulatedDividends, this.bars[i].getClose() / splitFactor - cumulatedDividends, (long)((double)this.bars[i].getVolume().longValue() * splitFactor));
            ++i;
        }
        return l;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (adapter.isAssignableFrom(PropertyChangeSupport.class)) {
            return this.propertyChangeSupport;
        }
        return null;
    }

    @Override
    public IStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(IStore store) {
        this.store = store;
    }

    @Override
    public IStoreProperties getStoreProperties() {
        if (this.storeProperties == null) {
            this.storeProperties = new StoreProperties();
        }
        this.storeProperties.setProperty("type", IHistory.class.getName());
        this.storeProperties.setProperty("security", this.security);
        this.storeProperties.setProperty("bars", this.bars);
        this.storeProperties.setProperty("bars-time-span", this.timeSpan);
        this.storeProperties.setProperty("splits", this.splits);
        return this.storeProperties;
    }

    @Override
    public void setStoreProperties(IStoreProperties storeProperties) {
        this.storeProperties = storeProperties;
        this.security = (ISecurity)storeProperties.getProperty("security");
        IOHLC[] bars = (IOHLC[])storeProperties.getProperty("bars");
        ArrayList l1 = bars != null ? Arrays.asList(bars) : new ArrayList();
        Collections.sort(l1, new Comparator<IOHLC>(){

            @Override
            public int compare(IOHLC o1, IOHLC o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        this.bars = l1.toArray(new IOHLC[l1.size()]);
        this.timeSpan = (TimeSpan)storeProperties.getProperty("bars-time-span");
        ISplit[] splits = (ISplit[])storeProperties.getProperty("splits");
        ArrayList l2 = splits != null ? Arrays.asList(splits) : new ArrayList();
        Collections.sort(l2, new Comparator<ISplit>(){

            @Override
            public int compare(ISplit o1, ISplit o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        this.splits = l2.toArray(new ISplit[l2.size()]);
        this.updateRange();
    }

    protected void updateRange() {
        this.highest = null;
        this.lowest = null;
        IOHLC[] iOHLCArray = this.bars;
        int n = this.bars.length;
        int n2 = 0;
        while (n2 < n) {
            IOHLC b = iOHLCArray[n2];
            if (this.highest == null || b.getHigh() > this.highest.getHigh()) {
                this.highest = b;
            }
            if (this.lowest == null || b.getLow() < this.lowest.getLow()) {
                this.lowest = b;
            }
            ++n2;
        }
    }

    protected void updateSubsets() {
        for (Key key : this.historyMap.keySet()) {
            WeakReference<HistoryDay> reference = this.historyMap.get(key);
            HistoryDay history = (HistoryDay)reference.get();
            if (history == null || !history.getTimeSpan().equals(this.timeSpan)) continue;
            IOHLC[] subset = this.getOHLCSubset(key.getFirst(), key.getLast());
            history.setOHLC(subset);
        }
    }

    private class Key {
        private Date first;
        private Date last;
        private TimeSpan timeSpan;

        public Key(Date first, Date last, TimeSpan timeSpan) {
            this.first = first;
            this.last = last;
            this.timeSpan = timeSpan;
        }

        public Date getFirst() {
            return this.first;
        }

        public Date getLast() {
            return this.last;
        }

        public boolean isInRange(Date date) {
            if (this.first != null && date.before(this.first)) {
                return false;
            }
            return this.last == null || !date.after(this.last);
        }

        public int hashCode() {
            int hash = 13 * this.timeSpan.hashCode();
            if (this.first != null) {
                hash += 7 * this.first.hashCode();
            }
            if (this.last != null) {
                hash += 11 * this.last.hashCode();
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            return this.hashCode() == obj.hashCode();
        }
    }
}

