/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.instruments;

import java.util.Currency;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.instruments.ICurrencyExchange;
import org.eclipsetrader.core.instruments.Security;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreProperties;

public class CurrencyExchange
extends Security
implements ICurrencyExchange {
    private Currency from;
    private Currency to;
    private Double multiplier;

    protected CurrencyExchange() {
    }

    public CurrencyExchange(Currency from, Currency to, double multiplier) {
        this.from = from;
        this.to = to;
        this.multiplier = multiplier;
    }

    public CurrencyExchange(String name, IFeedIdentifier identifier, Currency from, Currency to, double multiplier) {
        super(name, identifier);
        this.from = from;
        this.to = to;
        this.multiplier = multiplier;
    }

    public CurrencyExchange(IStore store, IStoreProperties storeProperties) {
        super(store, storeProperties);
    }

    @Override
    public Currency getFromCurrency() {
        return this.from;
    }

    public void setFromCurrency(Currency from) {
        this.from = from;
    }

    @Override
    public Currency getToCurrency() {
        return this.to;
    }

    public void setToCurrency(Currency to) {
        this.to = to;
    }

    @Override
    public Double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(Double multiplier) {
        this.multiplier = multiplier;
    }

    @Override
    public IStoreProperties getStoreProperties() {
        IStoreProperties storeProperties = super.getStoreProperties();
        storeProperties.setProperty("type", ICurrencyExchange.class.getName());
        storeProperties.setProperty("from-currency", this.from);
        storeProperties.setProperty("to-currency", this.to);
        storeProperties.setProperty("multiplier", this.multiplier);
        return storeProperties;
    }

    @Override
    public void setStoreProperties(IStoreProperties storeProperties) {
        super.setStoreProperties(storeProperties);
        this.from = (Currency)storeProperties.getProperty("from-currency");
        this.to = (Currency)storeProperties.getProperty("to-currency");
        this.multiplier = (Double)storeProperties.getProperty("multiplier");
    }
}

