/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.instruments;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.instruments.IUserProperties;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.repositories.StoreProperties;

public class Security
implements ISecurity,
IStoreObject {
    private String name;
    private IFeedIdentifier identifier;
    private IUserProperties userProperties;
    private IStore store;
    private IStoreProperties storeProperties;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Security.this.propertyChangeSupport.firePropertyChange("identifier", null, Security.this.identifier);
        }
    };

    protected Security() {
    }

    public Security(String name, IFeedIdentifier identifier) {
        this.name = name;
        this.identifier = identifier;
    }

    public Security(IStore store, IStoreProperties storeProperties) {
        this.setStore(store);
        this.setStoreProperties(storeProperties);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", oldValue, this.name);
    }

    @Override
    public IFeedIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(IFeedIdentifier identifier) {
        PropertyChangeSupport propertyChangeSupport;
        IFeedIdentifier oldValue = this.identifier;
        if (this.identifier != null && (propertyChangeSupport = (PropertyChangeSupport)this.identifier.getAdapter(PropertyChangeSupport.class)) != null) {
            propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.identifier = identifier;
        if (this.identifier != null && (propertyChangeSupport = (PropertyChangeSupport)this.identifier.getAdapter(PropertyChangeSupport.class)) != null) {
            propertyChangeSupport.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.propertyChangeSupport.firePropertyChange("identifier", oldValue, this.identifier);
    }

    @Override
    public IUserProperties getProperties() {
        return this.userProperties;
    }

    public void setProperties(IUserProperties userProperties) {
        IUserProperties oldValue = this.userProperties;
        this.userProperties = userProperties;
        this.propertyChangeSupport.firePropertyChange("user-properties", oldValue, this.userProperties);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (this.identifier != null && adapter.isAssignableFrom(this.identifier.getClass())) {
            return this.identifier;
        }
        if (this.userProperties != null && adapter.isAssignableFrom(this.userProperties.getClass())) {
            return this.userProperties;
        }
        if (adapter.isAssignableFrom(PropertyChangeSupport.class)) {
            return this.propertyChangeSupport;
        }
        return null;
    }

    @Override
    public IStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(IStore store) {
        this.store = store;
    }

    @Override
    public IStoreProperties getStoreProperties() {
        if (this.storeProperties == null) {
            this.storeProperties = new StoreProperties();
        }
        this.storeProperties.setProperty("type", ISecurity.class.getName());
        this.storeProperties.setProperty("name", this.getName());
        this.storeProperties.setProperty("identifier", this.getIdentifier());
        this.storeProperties.setProperty("user-properties", this.getProperties());
        return this.storeProperties;
    }

    @Override
    public void setStoreProperties(IStoreProperties storeProperties) {
        PropertyChangeSupport propertyChangeSupport;
        this.storeProperties = storeProperties;
        if (this.identifier != null && (propertyChangeSupport = (PropertyChangeSupport)this.identifier.getAdapter(PropertyChangeSupport.class)) != null) {
            propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.name = (String)storeProperties.getProperty("name");
        this.identifier = (IFeedIdentifier)storeProperties.getProperty("identifier");
        this.userProperties = (IUserProperties)storeProperties.getProperty("user-properties");
        if (this.identifier != null && (propertyChangeSupport = (PropertyChangeSupport)this.identifier.getAdapter(PropertyChangeSupport.class)) != null) {
            propertyChangeSupport.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ISecurity)) {
            return false;
        }
        ISecurity other = (ISecurity)obj;
        if (!this.name.equals(other.getName())) {
            return false;
        }
        if (this.identifier == null && other.getIdentifier() != null) {
            return false;
        }
        return this.identifier == null || this.identifier.equals(other.getIdentifier());
    }

    public String toString() {
        return this.name;
    }
}

