/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.instruments;

import java.util.Currency;
import org.eclipsetrader.core.feed.IDividend;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.instruments.IStock;
import org.eclipsetrader.core.instruments.Security;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreProperties;

public class Stock
extends Security
implements IStock {
    private Currency currency;
    private IDividend[] dividends;

    protected Stock() {
    }

    public Stock(String name, IFeedIdentifier identifier, Currency currency) {
        super(name, identifier);
        this.currency = currency;
    }

    public Stock(IStore store, IStoreProperties storeProperties) {
        super(store, storeProperties);
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    @Override
    public IDividend[] getDividends() {
        return this.dividends;
    }

    public void setDividends(IDividend[] dividends) {
        this.dividends = dividends;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(Currency.class)) {
            return this.currency;
        }
        if (this.dividends != null && adapter.isAssignableFrom(this.dividends.getClass())) {
            return this.dividends;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IStoreProperties getStoreProperties() {
        IStoreProperties storeProperties = super.getStoreProperties();
        storeProperties.setProperty("type", IStock.class.getName());
        storeProperties.setProperty("currency", this.currency);
        if (this.dividends != null) {
            storeProperties.setProperty("dividends", this.dividends);
        }
        return storeProperties;
    }

    @Override
    public void setStoreProperties(IStoreProperties storeProperties) {
        super.setStoreProperties(storeProperties);
        this.currency = (Currency)storeProperties.getProperty("currency");
        this.dividends = (IDividend[])storeProperties.getProperty("dividends");
    }
}

