/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.ICurrencyService;
import org.eclipsetrader.core.ats.ITradingSystemService;
import org.eclipsetrader.core.feed.IBackfillConnector;
import org.eclipsetrader.core.feed.IFeedConnector;
import org.eclipsetrader.core.feed.IFeedService;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CurrencyService;
import org.eclipsetrader.core.internal.CurrencyServiceFactory;
import org.eclipsetrader.core.internal.ats.TradingSystemService;
import org.eclipsetrader.core.internal.ats.TradingSystemServiceFactory;
import org.eclipsetrader.core.internal.feed.ConnectorOverrideAdapter;
import org.eclipsetrader.core.internal.feed.FeedService;
import org.eclipsetrader.core.internal.feed.FeedServiceFactory;
import org.eclipsetrader.core.internal.markets.MarketService;
import org.eclipsetrader.core.internal.markets.MarketServiceFactory;
import org.eclipsetrader.core.internal.repositories.RepositoryService;
import org.eclipsetrader.core.internal.trading.AlertService;
import org.eclipsetrader.core.internal.trading.MarketBrokerAdapterFactory;
import org.eclipsetrader.core.internal.trading.TradingService;
import org.eclipsetrader.core.internal.trading.TradingServiceFactory;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.repositories.IRepositoryElementFactory;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.trading.IAlertService;
import org.eclipsetrader.core.trading.ITradingService;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class CoreActivator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipsetrader.core";
    public static final String ELEMENT_FACTORY_ID = "org.eclipsetrader.core.elementFactories";
    public static final String REPOSITORY_ID = "org.eclipsetrader.core.repositories";
    public static final String PROVIDERS_FACTORY_ID = "org.eclipsetrader.core.providers";
    public static final String BROKERS_EXTENSION_ID = "org.eclipsetrader.core.trading.brokers";
    public static final String ALERTS_EXTENSION_ID = "org.eclipsetrader.core.trading.alerts";
    public static final String STRATEGIES_EXTENSION_ID = "org.eclipsetrader.core.ats.systems";
    public static final String SCRIPTS_EXTENSION_ID = "org.eclipsetrader.core.ats.javascript";
    public static final String DEFAULT_CONNECTOR_ID = "DEFAULT_CONNECTOR";
    public static final String DEFAULT_BACKFILL_CONNECTOR_ID = "DEFAULT_BACKFILL_CONNECTOR";
    private static CoreActivator plugin;
    private RepositoryService repositoryService;
    private ServiceRegistration repositoryServiceRegistration;
    private FeedServiceFactory feedServiceFactory;
    private ServiceRegistration feedServiceRegistration;
    private MarketServiceFactory marketServiceFactory;
    private ServiceRegistration marketServiceRegistration;
    private CurrencyServiceFactory currencyServiceFactory;
    private ServiceRegistration currencyServiceRegistration;
    private TradingServiceFactory tradingServiceFactory;
    private ServiceRegistration tradingServiceRegistration;
    private AlertService alertService;
    private ServiceRegistration alertServiceRegistration;
    private MarketBrokerAdapterFactory marketBrokerFactory;
    private TradingSystemServiceFactory tradingSystemServiceFactory;
    private ServiceRegistration tradingSystemServiceRegistration;
    private Map<String, IRepositoryElementFactory> elementFactoryMap = new HashMap<String, IRepositoryElementFactory>();
    private Map<String, IDataProviderFactory> providersFactoryMap = new HashMap<String, IDataProviderFactory>();
    private ConnectorOverrideAdapter overrideAdapter;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.repositoryService = new RepositoryService();
        this.repositoryServiceRegistration = context.registerService(new String[]{IRepositoryService.class.getName(), RepositoryService.class.getName()}, (Object)this.repositoryService, new Hashtable());
        this.repositoryService.startUp();
        this.feedServiceFactory = new FeedServiceFactory();
        this.feedServiceRegistration = context.registerService(new String[]{IFeedService.class.getName(), FeedService.class.getName()}, (Object)this.feedServiceFactory, new Hashtable());
        this.marketServiceFactory = new MarketServiceFactory();
        this.marketServiceRegistration = context.registerService(new String[]{IMarketService.class.getName(), MarketService.class.getName()}, (Object)this.marketServiceFactory, new Hashtable());
        this.currencyServiceFactory = new CurrencyServiceFactory();
        this.currencyServiceRegistration = context.registerService(new String[]{ICurrencyService.class.getName(), CurrencyService.class.getName()}, (Object)this.currencyServiceFactory, new Hashtable());
        this.marketBrokerFactory = new MarketBrokerAdapterFactory(this.getStateLocation().append("market_brokers.xml").toFile());
        AdapterManager.getDefault().registerAdapters((IAdapterFactory)this.marketBrokerFactory, IMarket.class);
        this.tradingServiceFactory = new TradingServiceFactory();
        this.tradingServiceRegistration = context.registerService(new String[]{ITradingService.class.getName(), TradingService.class.getName()}, (Object)this.tradingServiceFactory, new Hashtable());
        this.alertService = new AlertService();
        this.alertServiceRegistration = context.registerService(new String[]{IAlertService.class.getName(), AlertService.class.getName()}, (Object)this.alertService, new Hashtable());
        this.alertService.startUp();
        this.tradingSystemServiceFactory = new TradingSystemServiceFactory(this.repositoryService);
        this.tradingSystemServiceRegistration = context.registerService(new String[]{ITradingSystemService.class.getName(), TradingSystemService.class.getName()}, (Object)this.tradingSystemServiceFactory, new Hashtable());
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PROVIDERS_FACTORY_ID);
        if (extensionPoint != null) {
            IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String strID = configElements[j].getAttribute("id");
                try {
                    IDataProviderFactory factory = (IDataProviderFactory)configElements[j].createExecutableExtension("class");
                    this.providersFactoryMap.put(strID, factory);
                }
                catch (Exception e) {
                    Status status = new Status(2, PLUGIN_ID, 0, "Unable to create data provider factory with id " + strID, (Throwable)e);
                    this.getLog().log((IStatus)status);
                }
                ++j;
            }
        }
        try {
            this.overrideAdapter = new ConnectorOverrideAdapter(this.getStateLocation().append("overrides.xml").toFile());
            AdapterManager.getDefault().registerAdapters((IAdapterFactory)this.overrideAdapter, ISecurity.class);
        }
        catch (Exception e) {
            Status status = new Status(4, PLUGIN_ID, 0, "Error reading override settings", (Throwable)e);
            this.getLog().log((IStatus)status);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.tradingSystemServiceRegistration.unregister();
        this.tradingSystemServiceFactory.dispose();
        this.alertServiceRegistration.unregister();
        this.alertService.shutDown();
        this.tradingServiceRegistration.unregister();
        this.tradingServiceFactory.dispose();
        this.marketBrokerFactory.save(this.getStateLocation().append("market_brokers.xml").toFile());
        try {
            if (this.overrideAdapter != null) {
                this.overrideAdapter.save(this.getStateLocation().append("overrides.xml").toFile());
            }
        }
        catch (Exception e) {
            Status status = new Status(4, PLUGIN_ID, 0, "Error saving override settings", (Throwable)e);
            this.getLog().log((IStatus)status);
        }
        this.currencyServiceRegistration.unregister();
        this.currencyServiceFactory.dispose();
        this.marketServiceRegistration.unregister();
        this.marketServiceFactory.dispose();
        this.feedServiceRegistration.unregister();
        this.feedServiceFactory.dispose();
        this.repositoryServiceRegistration.unregister();
        this.repositoryService.shutDown();
        plugin = null;
        super.stop(context);
    }

    public static CoreActivator getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        if (plugin == null) {
            if (status.getException() != null) {
                status.getException().printStackTrace();
            }
            return;
        }
        plugin.getLog().log(status);
    }

    public static void log(String message, Throwable throwable) {
        Status status = new Status(4, PLUGIN_ID, message, throwable);
        if (plugin == null) {
            if (status.getException() != null) {
                status.getException().printStackTrace();
            }
            return;
        }
        plugin.getLog().log((IStatus)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRepositoryElementFactory getElementFactory(String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ELEMENT_FACTORY_ID);
        if (extensionPoint == null) {
            return null;
        }
        Map<String, IRepositoryElementFactory> map = this.elementFactoryMap;
        synchronized (map) {
            IRepositoryElementFactory factory = this.elementFactoryMap.get(targetID);
            if (factory == null) {
                IConfigurationElement targetElement = null;
                IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String strID = configElements[j].getAttribute("id");
                    if (targetID.equals(strID)) {
                        targetElement = configElements[j];
                        break;
                    }
                    ++j;
                }
                if (targetElement == null) {
                    return null;
                }
                try {
                    factory = (IRepositoryElementFactory)targetElement.createExecutableExtension("class");
                    this.elementFactoryMap.put(targetID, factory);
                }
                catch (Exception e) {
                    Status status = new Status(2, PLUGIN_ID, 0, "Unable to create factory with id " + targetID, (Throwable)e);
                    this.getLog().log((IStatus)status);
                }
            }
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDataProviderFactory getDataProviderFactory(String targetID) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PROVIDERS_FACTORY_ID);
        if (extensionPoint == null) {
            return null;
        }
        Map<String, IDataProviderFactory> map = this.providersFactoryMap;
        synchronized (map) {
            IDataProviderFactory factory = this.providersFactoryMap.get(targetID);
            if (factory == null) {
                IConfigurationElement targetElement = null;
                IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String strID = configElements[j].getAttribute("id");
                    if (targetID.equals(strID)) {
                        targetElement = configElements[j];
                        break;
                    }
                    ++j;
                }
                if (targetElement == null) {
                    return null;
                }
                try {
                    factory = (IDataProviderFactory)targetElement.createExecutableExtension("class");
                    this.providersFactoryMap.put(targetID, factory);
                }
                catch (Exception e) {
                    Status status = new Status(2, PLUGIN_ID, 0, "Unable to create data provider factory with id " + targetID, (Throwable)e);
                    this.getLog().log((IStatus)status);
                }
            }
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDataProviderFactory[] getDataProviderFactories() {
        Map<String, IDataProviderFactory> map = this.providersFactoryMap;
        synchronized (map) {
            Collection<IDataProviderFactory> c = this.providersFactoryMap.values();
            return c.toArray(new IDataProviderFactory[c.size()]);
        }
    }

    public IFeedConnector getDefaultConnector() {
        IFeedConnector connector = null;
        BundleContext context = this.getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IFeedService.class.getName());
        if (serviceReference != null) {
            IFeedService service = (IFeedService)context.getService(serviceReference);
            if (service != null) {
                connector = service.getConnector(this.getPluginPreferences().getString(DEFAULT_CONNECTOR_ID));
            }
            context.ungetService(serviceReference);
        }
        return connector;
    }

    public IBackfillConnector getDefaultBackfillConnector() {
        IBackfillConnector connector = null;
        BundleContext context = this.getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IFeedService.class.getName());
        if (serviceReference != null) {
            IFeedService service = (IFeedService)context.getService(serviceReference);
            if (service != null) {
                connector = service.getBackfillConnector(this.getPluginPreferences().getString(DEFAULT_BACKFILL_CONNECTOR_ID));
            }
            context.ungetService(serviceReference);
        }
        return connector;
    }
}

