/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal;

import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipsetrader.core.Cash;
import org.eclipsetrader.core.ICurrencyService;
import org.eclipsetrader.core.feed.IHistory;
import org.eclipsetrader.core.feed.ILastClose;
import org.eclipsetrader.core.feed.IOHLC;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.instruments.ICurrencyExchange;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.markets.MarketPricingEnvironment;
import org.eclipsetrader.core.repositories.IRepositoryChangeListener;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.RepositoryChangeEvent;
import org.eclipsetrader.core.repositories.RepositoryResourceDelta;

public class CurrencyService
implements ICurrencyService {
    private IRepositoryService repositoryService;
    private MarketPricingEnvironment pricingEnvironment;
    private List<ICurrencyExchange> exchanges = new ArrayList<ICurrencyExchange>();
    private IRepositoryChangeListener repositoryListener = new IRepositoryChangeListener(){

        @Override
        public void repositoryResourceChanged(RepositoryChangeEvent event) {
            RepositoryResourceDelta[] repositoryResourceDeltaArray = event.getDeltas();
            int n = repositoryResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                RepositoryResourceDelta delta = repositoryResourceDeltaArray[n2];
                if (delta.getResource() instanceof ICurrencyExchange) {
                    ICurrencyExchange exchange = (ICurrencyExchange)delta.getResource();
                    if (delta.getKind() == 1) {
                        if (!CurrencyService.this.exchanges.contains(exchange)) {
                            CurrencyService.this.exchanges.add(exchange);
                        }
                    } else if (delta.getKind() == 2) {
                        CurrencyService.this.exchanges.remove(exchange);
                    }
                }
                ++n2;
            }
        }
    };

    public CurrencyService(IRepositoryService repositoryService, IMarketService marketService) {
        this.repositoryService = repositoryService;
        this.pricingEnvironment = new MarketPricingEnvironment(marketService);
    }

    protected CurrencyService(IRepositoryService repositoryService, MarketPricingEnvironment pricingEnvironment) {
        this.repositoryService = repositoryService;
        this.pricingEnvironment = pricingEnvironment;
    }

    public void startUp(IProgressMonitor monitor) throws Exception {
        ISecurity[] iSecurityArray = this.repositoryService.getSecurities();
        int n = iSecurityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISecurity security = iSecurityArray[n2];
            ICurrencyExchange exchange = (ICurrencyExchange)security.getAdapter(ICurrencyExchange.class);
            if (exchange != null) {
                this.exchanges.add(exchange);
                this.pricingEnvironment.addSecurity(security);
            }
            ++n2;
        }
        this.repositoryService.addRepositoryResourceListener(this.repositoryListener);
    }

    public void shutDown(IProgressMonitor monitor) throws Exception {
        this.pricingEnvironment.dispose();
        this.repositoryService.removeRepositoryResourceListener(this.repositoryListener);
    }

    @Override
    public void addExchange(ICurrencyExchange exchange) {
        this.exchanges.add(exchange);
        ISecurity security = (ISecurity)exchange.getAdapter(ISecurity.class);
        if (security != null) {
            this.pricingEnvironment.addSecurity(security);
        }
    }

    @Override
    public void removeExchange(ICurrencyExchange exchange) {
        ISecurity security = (ISecurity)exchange.getAdapter(ISecurity.class);
        if (security != null) {
            this.pricingEnvironment.removeSecurity(security);
        }
        this.exchanges.remove(exchange);
    }

    @Override
    public Currency[] getAvailableCurrencies() {
        HashSet<Currency> set = new HashSet<Currency>();
        for (ICurrencyExchange xchg : this.exchanges) {
            set.add(xchg.getFromCurrency());
            set.add(xchg.getToCurrency());
        }
        return set.toArray(new Currency[set.size()]);
    }

    @Override
    public Cash convert(Cash cash, Currency currency) {
        ILastClose lastClose;
        ITrade trade;
        double multiplier;
        if (cash.getCurrency().equals(currency)) {
            return new Cash(cash.getAmount(), currency);
        }
        for (ICurrencyExchange xchg : this.exchanges) {
            if (!xchg.getFromCurrency().equals(cash.getCurrency()) || !xchg.getToCurrency().equals(currency)) continue;
            multiplier = xchg.getMultiplier() != null ? xchg.getMultiplier() : 1.0;
            trade = this.pricingEnvironment.getTrade((ISecurity)xchg.getAdapter(ISecurity.class));
            if (trade != null) {
                return new Cash(cash.getAmount() * trade.getPrice() * multiplier, currency);
            }
            lastClose = this.pricingEnvironment.getLastClose((ISecurity)xchg.getAdapter(ISecurity.class));
            if (lastClose == null) continue;
            return new Cash(cash.getAmount() * lastClose.getPrice() * multiplier, currency);
        }
        for (ICurrencyExchange xchg : this.exchanges) {
            if (!xchg.getToCurrency().equals(cash.getCurrency()) || !xchg.getFromCurrency().equals(currency)) continue;
            multiplier = xchg.getMultiplier() != null ? xchg.getMultiplier() : 1.0;
            trade = this.pricingEnvironment.getTrade((ISecurity)xchg.getAdapter(ISecurity.class));
            if (trade != null) {
                return new Cash(cash.getAmount() / trade.getPrice() / multiplier, currency);
            }
            lastClose = this.pricingEnvironment.getLastClose((ISecurity)xchg.getAdapter(ISecurity.class));
            if (lastClose == null) continue;
            return new Cash(cash.getAmount() / lastClose.getPrice() / multiplier, currency);
        }
        return null;
    }

    @Override
    public Cash convert(Cash cash, Currency currency, Date date) {
        IOHLC[] ohlc;
        IHistory history;
        ISecurity security;
        double multiplier;
        if (cash.getCurrency().equals(currency)) {
            return new Cash(cash.getAmount(), currency);
        }
        for (ICurrencyExchange xchg : this.exchanges) {
            if (!xchg.getFromCurrency().equals(cash.getCurrency()) || !xchg.getToCurrency().equals(currency)) continue;
            multiplier = xchg.getMultiplier() != null ? xchg.getMultiplier() : 1.0;
            security = (ISecurity)xchg.getAdapter(ISecurity.class);
            history = this.repositoryService.getHistoryFor(security);
            ohlc = (history = history.getSubset(date, date)).getOHLC();
            if (ohlc.length == 0) continue;
            return new Cash(cash.getAmount() * ohlc[0].getClose() * multiplier, currency);
        }
        for (ICurrencyExchange xchg : this.exchanges) {
            if (!xchg.getToCurrency().equals(cash.getCurrency()) || !xchg.getFromCurrency().equals(currency)) continue;
            multiplier = xchg.getMultiplier() != null ? xchg.getMultiplier() : 1.0;
            security = (ISecurity)xchg.getAdapter(ISecurity.class);
            history = this.repositoryService.getHistoryFor(security);
            ohlc = (history = history.getSubset(date, date)).getOHLC();
            if (ohlc.length == 0) continue;
            return new Cash(cash.getAmount() / ohlc[0].getClose() / multiplier, currency);
        }
        return null;
    }
}

